package com.yaoyaozw.customer.configs;

import com.yaoyaozw.customer.constants.RabbitCommonNameConstant;
import org.springframework.amqp.core.Binding;
import org.springframework.amqp.core.BindingBuilder;
import org.springframework.amqp.core.DirectExchange;
import org.springframework.amqp.core.Queue;
import org.springframework.amqp.rabbit.config.SimpleRabbitListenerContainerFactory;
import org.springframework.amqp.rabbit.connection.ConnectionFactory;
import org.springframework.amqp.support.converter.Jackson2JsonMessageConverter;
import org.springframework.amqp.support.converter.MessageConverter;
import org.springframework.boot.autoconfigure.amqp.SimpleRabbitListenerContainerFactoryConfigurer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import java.util.HashMap;
import java.util.Map;

/**
 * @author darker
 * @date 2022/10/21 16:04
 */
@Configuration
public class RabbitConfig {

/*    @Bean
    public MessageConverter messageConverter(){
        return new Jackson2JsonMessageConverter();
    }*/
    @Bean("acquisitionExceptionFactory")
    public SimpleRabbitListenerContainerFactory acquisitionExceptionFactory(SimpleRabbitListenerContainerFactoryConfigurer configurer, ConnectionFactory connectionFactory) {
        SimpleRabbitListenerContainerFactory factory = new SimpleRabbitListenerContainerFactory();
        factory.setPrefetchCount(1);
        factory.setConcurrentConsumers(1);
        configurer.configure(factory, connectionFactory);
        return factory;
    }


    @Bean
    public Queue directQueue(){
        Map<String, Object> map = new HashMap<>(4);
        map.put("x-dead-letter-exchange", RabbitCommonNameConstant.DEATH_EXCHANGE);
        map.put("x-dead-letter-routing-key", RabbitCommonNameConstant.YG_LIMIT_DEATH_ROUTE_KEY);
        map.put("x-message-ttl", 60000);
        return new Queue(RabbitCommonNameConstant.YG_LIMIT_TTL_QUEUE, true, false, false, map);
    }

    @Bean
    public DirectExchange directExchange(){
        return new DirectExchange(RabbitCommonNameConstant.OPERATE_COMMON_EXCHANGE);
    }

    @Bean
    public Queue deathQueue(){
        return new Queue(RabbitCommonNameConstant.YG_LIMIT_DEATH_QUEUE);
    }

    @Bean
    public DirectExchange deathExchange(){
        return new DirectExchange(RabbitCommonNameConstant.DEATH_EXCHANGE);
    }

    @Bean
    public Binding bindingDirect(){
        return BindingBuilder.bind(directQueue()).to(directExchange()).with(RabbitCommonNameConstant.YG_LIMIT_TTL_ROUTE_KEY);
    }

    @Bean
    public Binding bindingDeath(){
        return BindingBuilder.bind(deathQueue()).to(deathExchange()).with(RabbitCommonNameConstant.YG_LIMIT_DEATH_ROUTE_KEY);
    }


}
