package com.yaoyaozw.customer.components;

import cn.hutool.core.lang.Snowflake;
import cn.hutool.core.util.IdUtil;
import cn.hutool.core.util.NetUtil;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import javax.annotation.PostConstruct;

/**
 * @author  darker
 * @date  2022/9/21 10:26
 */
@Component
@Slf4j
public class SnowflakeComponent {
    @JsonFormat(shape = JsonFormat.Shape.STRING)
    private long workerId ;
    private final long dataCenterId = 1;
    private final Snowflake snowFlake = IdUtil.createSnowflake(workerId,dataCenterId);
    @PostConstruct
    public void init(){
        workerId = NetUtil.ipv4ToLong(NetUtil.getLocalhostStr());
        log.info("当前机器的workId:{}",workerId);
    }
    public synchronized long snowflakeId(){
        return snowFlake.nextId();
    }
    public synchronized long snowflakeId(long workerId,long datacenterId){
        Snowflake snowflake = IdUtil.createSnowflake(workerId, datacenterId);
        return snowflake.nextId();
    }
}