package com.yaoyaozw.customer.service.impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.yaoyaozw.customer.common.BaseResult;
import com.yaoyaozw.customer.common.GenericsResult;
import com.yaoyaozw.customer.components.TokenManager;
import com.yaoyaozw.customer.dto.ConditionDTO;
import com.yaoyaozw.customer.dto.DistributeDTO;
import com.yaoyaozw.customer.dto.MenuMainCopyDTO;
import com.yaoyaozw.customer.dto.follow.FollowReplyCopyDTO;
import com.yaoyaozw.customer.dto.keyword.CustomerKeywordCopyDTO;
import com.yaoyaozw.customer.entity.AccountDistributeRecord;
import com.yaoyaozw.customer.feigns.MenuFeignClient;
import com.yaoyaozw.customer.mapper.AccountDistributeLogMapper;
import com.yaoyaozw.customer.service.CustomerFollowReplyService;
import com.yaoyaozw.customer.service.CustomerGraphicsDelayService;
import com.yaoyaozw.customer.service.CustomerKeywordService;
import com.yaoyaozw.customer.service.DistributeService;
import com.yaoyaozw.customer.vo.AccountDistributeLogVO;
import com.yaoyaozw.customer.vo.AuthInfoVO;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

/**
 * @Author: Dwl
 * @Date: 2024/03/27/17:22
 * @ClassName: DistributeServiceImpl
 * @Version: V3.2.0
 * @Description:
 */
@Slf4j
@Service
public class DistributeServiceImpl extends ServiceImpl<AccountDistributeLogMapper, AccountDistributeRecord> implements DistributeService {
    @Autowired
    private CustomerGraphicsDelayService customerGraphicsDelayService;

    @Autowired
    private CustomerKeywordService keywordService;

    @Autowired
    private CustomerFollowReplyService followReplyService;

    @Autowired
    private MenuFeignClient menuFeignClient;

    @Autowired
    private TokenManager tokenManager;


    @Override
    public BaseResult distribute(DistributeDTO distributeDTO) {
        Long userId = tokenManager.getUserIdFromToken();
        List<AccountDistributeRecord> distributeLogList = new ArrayList<>();
        log.info("开始执行复用任务....");
        AuthInfoVO sourceAuth = distributeDTO.getSourceAuth();
        List<String> targetAppList = distributeDTO.getTargetAppList();
        List<AuthInfoVO> targetAuthList = distributeDTO.getTargetAuthList();
        List<String> targetApp = targetAuthList.stream().map(AuthInfoVO::getAppId).collect(Collectors.toList());
        List<Long> idList = targetAuthList.stream().map(AuthInfoVO::getId).collect(Collectors.toList());
        List<String> typeList = distributeDTO.getTypeList();

        try {
            for (String type : typeList) {
                switch (type) {
                    case "1":
                        //关回复用
                        FollowReplyCopyDTO followReplyCopyDTO = new FollowReplyCopyDTO();
                        followReplyCopyDTO.setTargetAuthList(targetAuthList);
                        followReplyCopyDTO.setSourceAuth(sourceAuth);
                        followReplyService.copy(followReplyCopyDTO);
                        break;
                    case "2":
                        //关键词复用
                        CustomerKeywordCopyDTO customerKeywordCopyDTO = new CustomerKeywordCopyDTO();
                        customerKeywordCopyDTO.setSourceAuth(sourceAuth);
                        customerKeywordCopyDTO.setTargetKeywordList(targetAppList);
                        customerKeywordCopyDTO.setTargetAuthList(targetAuthList);
                        keywordService.copy(customerKeywordCopyDTO);
                        break;
                    case "3":
                        //延时客服复用
                        customerGraphicsDelayService.copy(sourceAuth.getAppId(), "", "", null, targetApp);
                        break;
                    case "4":
                        //菜单管理复用
                        MenuMainCopyDTO menuMainCopyDTO = new MenuMainCopyDTO();
                        menuMainCopyDTO.addList(sourceAuth.getId(), idList);
                        menuFeignClient.copy(menuMainCopyDTO);
                        break;
                    default:
                        break;
                }
            }
        } catch (Exception e) {
            log.error("Distribution reuse exception：{}", e.getMessage(), e);
        }


        idList.forEach(c -> {
            AccountDistributeRecord distributeLog = new AccountDistributeRecord();
            distributeLog.saveDistribute(sourceAuth.getId(), c, typeList, userId);
            distributeLogList.add(distributeLog);
        });

        this.saveBatch(distributeLogList);
        return new BaseResult().success("复用进行中, 请等待");
    }

    @Override
    public GenericsResult<PageInfo<AccountDistributeLogVO>> logList(ConditionDTO conditionDTO) {
        PageHelper.startPage(conditionDTO.getCurrentPage(), conditionDTO.getPageSize());
        List<AccountDistributeLogVO> accountDistributeLogVOList = this.baseMapper.selectLogList(conditionDTO);
        PageInfo<AccountDistributeLogVO> pageInfoList = new PageInfo<>(accountDistributeLogVOList);
        return new GenericsResult<>(pageInfoList);
    }
}
