package com.yaoyaozw.customer.controller;

import com.yaoyaozw.customer.annotations.AccountOperateControl;
import com.yaoyaozw.customer.annotations.OperateLog;
import com.yaoyaozw.customer.common.GenericsResult;
import com.yaoyaozw.customer.dto.customer.CustomerDelayTextSaveDTO;
import com.yaoyaozw.customer.entity.CommonReferralBody;
import com.yaoyaozw.customer.enums.AccountParamType;
import com.yaoyaozw.customer.enums.AccountTableColumnType;
import com.yaoyaozw.customer.service.CustomerDelayTextService;
import com.yaoyaozw.customer.vo.customer.CustomerDelayTextDetailVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

/**
 * @author darker
 * @date 2022/9/15 11:13
 */
@Api(tags = "延时客服接口-文本")
@RestController
@RequestMapping("/customer-service/delay/text")
public class CustomerDelayTextController {

    @Autowired
    private CustomerDelayTextService textService;

    @ApiOperation("新增客服主体")
    @PostMapping("/insertCustomerDelay")
    @OperateLog(module = "延时客服-文本", desc = "新增文本延时客服")
    @AccountOperateControl(paramType = AccountParamType.REQUEST_BODY, paramName = "saveDto", columnType = AccountTableColumnType.APP_ID, property = "appId")
    public GenericsResult<String> insertCustomerDelay(@RequestBody CustomerDelayTextSaveDTO saveDto) {
        return textService.insertCustomerDelay(saveDto);
    }

    @ApiOperation("新增客服内容")
    @PostMapping("/insertCustomerContent")
    @OperateLog(module = "延时客服-文本", desc = "新增文本延时客服子素材")
    public GenericsResult<CustomerDelayTextDetailVO> insertCustomerContent(@RequestBody CommonReferralBody referralDto) {
        return textService.insertCustomerContent(referralDto);
    }

    @ApiOperation("获取文本客服详情")
    @GetMapping("/detail/{id}")
    @AccountOperateControl(paramType = AccountParamType.TABLE_PRIMARY, paramName = "id", columnType = AccountTableColumnType.APP_ID, table = "customer_graphics_delay", column = "app_id")
    public GenericsResult<CustomerDelayTextDetailVO> getCustomerTextDetail(@PathVariable("id") Long id) {
        return textService.getCustomerTextDetail(id);
    }

    @ApiOperation("删除单条文本内容")
    @GetMapping("/removeCustomerContent/{contentId}")
    @OperateLog(module = "延时客服-文本", desc = "删除文本延时客服子素材")
    public GenericsResult<CustomerDelayTextDetailVO> removeCustomerContent(@PathVariable("contentId") Long contentId) {
        return textService.removeCustomerContent(contentId);
    }



}
