package com.yaoyaozw.customer.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.yaoyaozw.customer.mapper.MaterialCommonMapper;
import com.yaoyaozw.customer.service.CompanyAcquisitionLinkService;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;

@Slf4j
@Service
public class CompanyAcquisitionLinkServiceImpl implements CompanyAcquisitionLinkService {

    @Resource
    private MaterialCommonMapper materialCommonMapper;

    @Override
    public String checkAndSearchTargetReferral(String sourceReferral, Long targetAuthId) {
        // 查询 sourceReferral 这个链接是不是获客链接，如果不是，直接返回原链接
        String type = materialCommonMapper.getAppointReferralType(sourceReferral);
        if (StringUtils.isBlank(type)) {
            return sourceReferral;
        }
        // 原链接是获客链接，查询目标公众号的获客链接
        List<String> acquisitionLinkList = materialCommonMapper.getAcquisitionLinkList(targetAuthId, type);
        if (CollectionUtil.isEmpty(acquisitionLinkList)) {
            throw new RuntimeException("目标公众号无法获取获客链接");
        }
        if (acquisitionLinkList.size() > 1) {
            throw new RuntimeException("目标公众号存在多个有效获客链接");
        }
        return acquisitionLinkList.get(0);
    }
}
