package com.yaoyaozw.customer.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.yaoyaozw.customer.common.BaseResult;
import com.yaoyaozw.customer.common.GenericsResult;
import com.yaoyaozw.customer.dto.follow.FollowReplyCopyDTO;
import com.yaoyaozw.customer.dto.follow.FollowReplyQueryDTO;
import com.yaoyaozw.customer.dto.follow.FollowReplySaveDTO;
import com.yaoyaozw.customer.entity.CommonReferralBody;
import com.yaoyaozw.customer.entity.CustomerFollowReply;
import com.yaoyaozw.customer.vo.follow.FollowReplyInfoVO;
import com.yaoyaozw.customer.vo.follow.FollowReplyListVO;

import java.util.List;

/**
 * @author darker
 * @date 2023/3/14 11:14
 */
public interface CustomerFollowReplyService extends IService<CustomerFollowReply> {

    /**
     * 列表
     *
     * @param queryDto 查询dto
     * @return {@link GenericsResult}<{@link List}<{@link FollowReplyListVO}>>
     */
    GenericsResult<List<FollowReplyListVO>> list(FollowReplyQueryDTO queryDto);

    /**
     * 创建
     *
     * @param saveDto 保存dto
     * @return {@link GenericsResult}<{@link String}>
     */
    GenericsResult<String> create(FollowReplySaveDTO saveDto);

    /**
     * 创建文本项
     *
     * @param referralBody 推荐身体
     * @return {@link GenericsResult}<{@link List}<{@link CommonReferralBody}>>
     */
    GenericsResult<List<CommonReferralBody>> createTextItem(CommonReferralBody referralBody);

    /**
     * 删除
     *
     * @param id id
     * @return {@link BaseResult}
     */
    BaseResult remove(Long id);

    /**
     * 删除文本项
     *
     * @param id id
     * @return {@link GenericsResult}<{@link List}<{@link CommonReferralBody}>>
     */
    GenericsResult<List<CommonReferralBody>> removeTextItem(Long id);

    /**
     * 复制
     *
     * @param copyDto 复制dto
     * @return {@link BaseResult}
     */
    BaseResult copy(FollowReplyCopyDTO copyDto);

    /**
     * 得到信息
     *
     * @param id id
     * @return {@link GenericsResult}<{@link FollowReplyInfoVO}>
     */
    GenericsResult<FollowReplyInfoVO> getInfo(Long id);
}
