package com.yaoyaozw.customer.entity;

import com.baomidou.mybatisplus.annotation.*;
import lombok.Data;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.annotation.Id;

import java.io.Serializable;
import java.util.Date;

/**
 * @Author: Dwl
 * @Date: 2024/05/30/11:14
 * @ClassName: MaterialMenuConfigService
 * @Version: V3.2.0
 * @Description:
 */
@Data
@TableName("material_menu_config")
public class MaterialMenuConfig implements Serializable {
    /**
     *
     */
    @Id
    @TableId(value = "id", type = IdType.ID_WORKER)
    private Long id;

    /**
     * 公众号id
     */
    @TableField("auth_id")
    private Long authId;

    /**
     * appId
     */
    @TableField(exist = false)
    private String appId;

    /**
     * 配置名称
     */
    @TableField("config_name")
    private String configName;

    /**
     * 0-文本 1-图片 2-图文
     */
    @TableField("type")
    private Integer type;

    /**
     * 推广标题
     */
    @TableField("extend_title")
    private String extendTitle;

    /**
     * 图片地址
     */
    @TableField("img_url")
    private String imgUrl;

    /**
     * 文本内容【文本类型存H5代码】
     */
    @TableField("content")
    private String content;

    /**
     * 图文链接地址
     */
    @TableField("referral")
    private String referral;

    /**
     * 图片在公众号后台的地址
     */
    @TableField("media_id")
    private String mediaId;

    /**
     * 启用状态 0-启用 1-禁用
     */
    @TableField("status")
    private Integer status;

    /**
     * 逻辑删除
     */
    @TableField(value = "is_deleted", fill = FieldFill.INSERT)
    @TableLogic
    private Integer isDeleted;

    /**
     * 创建时间
     */
    @TableField(value = "gmt_create", fill = FieldFill.INSERT)
    private Date gmtCreate;

    /**
     * 创建人
     */
    @TableField(value = "gmt_create_user", fill = FieldFill.INSERT)
    private String gmtCreateUser;

    /**
     * 修改时间
     */
    @TableField(value = "gmt_modified", fill = FieldFill.INSERT_UPDATE)
    private Date gmtModified;

    /**
     * 修改人
     */
    @TableField(value = "gmt_modified_user", fill = FieldFill.INSERT_UPDATE)
    private String gmtModifiedUser;

    public String getContent() {
        if (StringUtils.isBlank(this.content)) {
            return null;
        }
        return content;
    }
}
