package com.yaoyaozw.customer.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.yaoyaozw.customer.dto.AcquisitionExceptionHandleParam;
import com.yaoyaozw.customer.entity.AuthorizerInfo;
import com.yaoyaozw.customer.entity.CompanyAcquisitionLink;
import com.yaoyaozw.customer.mapper.CompanyAcquisitionLinkMapper;
import com.yaoyaozw.customer.mapper.MaterialCommonMapper;
import com.yaoyaozw.customer.service.AuthorizerInfoService;
import com.yaoyaozw.customer.service.CompanyAcquisitionLinkService;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;

@Slf4j
@Service
public class CompanyAcquisitionLinkServiceImpl implements CompanyAcquisitionLinkService {

    @Resource
    private MaterialCommonMapper materialCommonMapper;
    @Resource
    private CompanyAcquisitionLinkMapper companyAcquisitionLinkMapper;
    @Resource
    private AuthorizerInfoService authorizerInfoService;

    @Override
    public String checkAndSearchTargetReferral(String sourceReferral, Long targetAuthId) {
        // 查询 sourceReferral 这个链接是不是获客链接，如果不是，直接返回原链接
        String type = materialCommonMapper.getAppointReferralType(sourceReferral);
        if (StringUtils.isBlank(type)) {
            return sourceReferral;
        }
        // 原链接是获客链接，查询目标公众号的获客链接
        List<String> acquisitionLinkList = materialCommonMapper.getAcquisitionLinkList(targetAuthId, type);
        if (CollectionUtil.isEmpty(acquisitionLinkList)) {
            throw new RuntimeException("目标公众号无法获取获客链接");
        }
/*        if (acquisitionLinkList.size() > 1) {
            throw new RuntimeException("目标公众号存在多个有效获客链接");
        }*/
        return acquisitionLinkList.get(0);
    }

    @Override
    public AcquisitionExceptionHandleParam getReplaceAcquisitionEntityByLinkId(String linkId) {
        // 查询链接绑定公众号信息
        CompanyAcquisitionLink acquisitionInfo;
        try {
            acquisitionInfo = companyAcquisitionLinkMapper.getAcquisitionInfoByLinkId(linkId);
        } catch (Exception e) {
            log.error("获取链接Id：{} 信息异常", linkId, e);
            return null;
        }
        if (acquisitionInfo == null) {
            log.error("无法获取链接Id：{} 信息", linkId);
            return null;
        }
        AuthorizerInfo authorizerInfo;
        try {
            authorizerInfo = authorizerInfoService.getOne(new QueryWrapper<AuthorizerInfo>().eq("appid", acquisitionInfo.getAuthAppId()));
        } catch (Exception e) {
            log.error("获取公众号信息异常：{}", acquisitionInfo.getAuthAppId(), e);
            return null;
        }
        if (authorizerInfo == null) {
            log.error("无法获取公众号信息：{}", acquisitionInfo.getAuthAppId());
            return null;
        }
        // 查询可替换使用的链接列表
        List<CompanyAcquisitionLink> availableAcquisitionList = companyAcquisitionLinkMapper.getAvailableAcquisitionListExceptLinkId(acquisitionInfo.getAuthAppId(), linkId);
        if (CollectionUtil.isEmpty(availableAcquisitionList)) {
            log.error("公众号：{} 无法获取可替换的链接", acquisitionInfo.getAuthAppId());
            return null;
        }
        // TODO: 2025/5/26 排除当天已经轮转过的链接
        return new AcquisitionExceptionHandleParam(authorizerInfo, acquisitionInfo.getLinkUrl(), availableAcquisitionList.get(0).getLinkUrl());
    }
}
