package com.yaoyaozw.customer.constants;

import org.apache.commons.lang3.StringUtils;

import java.util.Arrays;
import java.util.List;

/**
 * @author darker
 * @date 2023/3/14 11:56
 */
public class CustomerMaterialConstant {

    public final static String FOLLOW_REPLY_REDIS_KEY = "followReplyMap";
    public final static String CUSTOMER_KEYWORD_REDIS_KEY = "customerKeywordMap";

    public final static String FOLLOW_REPLY_MULTI_NEWS_CACHE_KEY = "followReplyMultiNews";

    public final static String TENCENT_MEDIA_TYPE_PIC = "image";
    public final static String TENCENT_MEDIA_TYPE_VOICE = "voice";
    public final static String TENCENT_MEDIA_TYPE_MINI_PROGRAM = "miniprogrampage";
    public final static String TENCENT_MEDIA_TYPE_NEWS = "news";
    public final static String TENCENT_MEDIA_TYPE_TEXT = "text";
    public final static String TENCENT_MEDIA_TYPE_MULTI_NEWS = "multi_news";


    public static Boolean needUpload(String type) {
        return TENCENT_MEDIA_TYPE_PIC.equals(type) || TENCENT_MEDIA_TYPE_VOICE.equals(type) || TENCENT_MEDIA_TYPE_MINI_PROGRAM.equals(type);
    }

    public static Boolean needReferral(String type) {
        return TENCENT_MEDIA_TYPE_NEWS.equals(type) || TENCENT_MEDIA_TYPE_TEXT.equals(type);
    }

    public static String getTypeDesc(String type) {

        if (TENCENT_MEDIA_TYPE_PIC.equals(type)) {
            return "图片";
        } else if (TENCENT_MEDIA_TYPE_VOICE.equals(type)) {
            return "语音";
        } else if (TENCENT_MEDIA_TYPE_NEWS.equals(type)) {
            return "图文";
        } else if (TENCENT_MEDIA_TYPE_TEXT.equals(type)) {
            return "文本";
        } else if (TENCENT_MEDIA_TYPE_MINI_PROGRAM.equals(type)) {
            return "小程序";
        }
        return "";

    }


}
