package com.yaoyaozw.customer.common;

import cn.hutool.core.util.ObjectUtil;
import com.yaoyaozw.customer.constants.ApiResultConstant;
import lombok.Data;

/**
 * @author darker
 * @date 2022/9/16 10:59
 */
@Data
public class BaseResult {

    /**
     * 结果标识码
     */
    protected Boolean success;

    /**
     * 返回信息描述
     */
    protected String message;

    /**
     * 结果码
     */
    protected Integer code;

    public BaseResult() {
    }

    public BaseResult success() {
        this.success = Boolean.TRUE;
        this.code = ApiResultConstant.SUCCESS_CODE;
        if (ObjectUtil.isNull(this.message)) {
            this.message = ApiResultConstant.SUCCESS_MSG;
        }
        return this;
    }

    /**
     * 错误
     *
     * @return {@link GenericsResult}
     */
    public BaseResult error() {
        this.success = Boolean.FALSE;
        this.code = ApiResultConstant.FAILURE_CODE;
        this.message = ApiResultConstant.FAILURE_MSG;
        return this;
    }

    /**
     * 错误
     *
     * @return {@link GenericsResult}
     */
    public BaseResult error(String message) {
        this.success = Boolean.FALSE;
        this.code = ApiResultConstant.FAILURE_CODE;
        this.message = message;
        return this;
    }

    
}
