package com.yaoyaozw.customer.mapper;

import com.baomidou.dynamic.datasource.annotation.DS;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.yaoyaozw.customer.dto.crowd.CrowdPackageQueryDTO;
import com.yaoyaozw.customer.entity.CrowdPackage;
import com.yaoyaozw.customer.entity.CrowdPackageCondition;
import com.yaoyaozw.customer.vo.kanban.CommonOptionResponseVO;
import com.yaoyaozw.customer.vo.crowd.CrowdPackageListVO;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * @author darker
 * @date 2022/9/16 10:44
 */
@DS("material")
@Repository
public interface MaterialCrowdPackageMapper extends BaseMapper<CrowdPackage> {

    /**
     * 根据条件配置获取条件选项
     *
     * @param conditionItem 条件项
     * @return {@link List}<{@link CommonOptionResponseVO}>
     */
    List<CommonOptionResponseVO> getConditionOptionByConfig(@Param("conditionItem") CrowdPackageCondition conditionItem);


    /**
     * 获得页面列表
     *
     * @param queryDto 查询dto
     * @return {@link List}<{@link CrowdPackageListVO}>
     */
    List<CrowdPackageListVO> getPageList(@Param("queryDto") CrowdPackageQueryDTO queryDto);


    /**
     * 删除条件
     *
     * @param linkedId 相关id
     */
    void removeCondition(@Param("linkedId") Long linkedId);
}
