package com.yaoyaozw.customer.mapper;

import com.baomidou.dynamic.datasource.annotation.DS;
import com.yaoyaozw.customer.common.GenericsResult;
import com.yaoyaozw.customer.entity.CustomerCommonLink;
import com.yaoyaozw.customer.vo.AuthInfoVO;
import com.yaoyaozw.customer.vo.kanban.CommonOptionResponseVO;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import java.util.List;
import java.util.Set;

/**
 * @author darker
 * @date 2022/10/9 10:31
 */
@Repository
@DS("material")
public interface MaterialCommonMapper {


    /**
     * 获取存储列表
     *
     * @return {@link List}<{@link CommonOptionResponseVO}>
     */
    List<CommonOptionResponseVO> getStoreList();

    /**
     * 获得身份验证信息列表
     *
     * @param accountSet 帐户设置
     * @return {@link List}<{@link AuthInfoVO}>
     */
    List<AuthInfoVO> getAuthInfoList(@Param("accountSet") Set<String> accountSet);

    /**
     * 把封面图片列表
     *
     * @return {@link CommonOptionResponseVO}
     */
    List<CommonOptionResponseVO> getCoverPicList();

    /**
     * 让常见链接列表
     *
     * @return {@link List}<{@link CommonOptionResponseVO}
     */
    List<CommonOptionResponseVO> getCommonLinkList();

    /**
     * 让共同链接映射
     *
     * @param currentKey 当前key
     * @return {@link List}<{@link CustomerCommonLink}>
     */
    List<CustomerCommonLink> getCommonLinkMapping(@Param("currentKey") String currentKey);

    /**
     * @param appId 应用程序id
     * @return {@link String}
     */
    String getStoreTypeNameByAppId(@Param("appId") String appId);


    /**
     * 获取指定公众号的指定获客链接数量
     * @param appointReferral 指定获客链接
     * @return 数量
     */
    String getAppointReferralType(@Param("appointReferral") String appointReferral);


    /**
     * 获取指定公众号的获客链接列表
     *
     * @param targetAuthId 指定公众号
     * @return 获客链接列表
     */
    List<String> getAcquisitionLinkList(@Param("targetAuthId") Long targetAuthId, @Param("type") String type);

    /**
     * 获取指定公众号的指定获客链接列表
     *
     * @param appId 账号
     * @param type  类型
     * @return 获客链接列表
     */
    List<String> getAcquisitionLinkListByAppIdAndType(@Param("appId") String appId, @Param("type") String type);

}
