package com.yaoyaozw.customer.dto.customer;

import cn.hutool.core.util.ObjectUtil;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * @author darker
 * @date 2022/10/12 16:33
 */
@Data
@ApiModel("文本类型客服保存实体")
public class CustomerDelayTextSaveDTO implements Serializable {

    @ApiModelProperty("客服消息id")
    private Long id;

    @ApiModelProperty("公众号AppId")
    private String appId;

    @ApiModelProperty("标题")
    private String name;

    @ApiModelProperty("发文序号")
    private Integer postSort;

    @ApiModelProperty("发文间隔时间")
    private Long timeInterval;

    @ApiModelProperty("已支付、未支付")
    private Integer isPay;

    @ApiModelProperty("客服消息类型(图文、文本)")
    private String type;

    private Integer hour;

    private Integer minute;

    public Long getTimeInterval() {
        long stamp = 0L;
        if (ObjectUtil.isNotNull(this.hour)) {
            stamp += this.hour * 1000 * 60 * 60;
        }
        if (ObjectUtil.isNotNull(this.minute)) {
            stamp += this.minute * 1000 * 60;
        }
        return stamp == 0 ? null : stamp;
    }

}
