package com.yaoyaozw.customer.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.yaoyaozw.customer.common.BaseResult;
import com.yaoyaozw.customer.common.GenericsResult;
import com.yaoyaozw.customer.components.SnowflakeComponent;
import com.yaoyaozw.customer.components.TokenManager;
import com.yaoyaozw.customer.constants.CustomerCommonConstant;
import com.yaoyaozw.customer.dto.customer.CustomerMessageMiniProgramSaveDTO;
import com.yaoyaozw.customer.entity.CustomerGraphics;
import com.yaoyaozw.customer.entity.ReferralEntity;
import com.yaoyaozw.customer.exception.BaseException;
import com.yaoyaozw.customer.mapper.CustomerGraphicsMapper;
import com.yaoyaozw.customer.mapper.KanbanCommonMapper;
import com.yaoyaozw.customer.service.CustomerGraphicsMiniProgramService;
import com.yaoyaozw.customer.service.CustomerServiceCommonService;
import com.yaoyaozw.customer.service.ReferralEntityService;
import com.yaoyaozw.customer.utils.HttpClientUtil;
import com.yaoyaozw.customer.vo.AuthInfoVO;
import com.yaoyaozw.customer.vo.customer.CrowdPackageUserVO;
import com.yaoyaozw.customer.vo.kanban.CommonOptionResponseVO;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.*;
import java.util.stream.Collectors;

@Service
public class CustomerGraphicsMiniProgramServiceImpl extends ServiceImpl<CustomerGraphicsMapper, CustomerGraphics> implements CustomerGraphicsMiniProgramService {

    private final static Logger LOCAL_LOG = LoggerFactory.getLogger(CustomerGraphicsMiniProgramServiceImpl.class);

    @Autowired
    private TokenManager tokenManager;

    @Autowired
    private SnowflakeComponent snowflakeComponent;

    @Autowired
    private ReferralEntityService referralEntityService;

    @Autowired
    private KanbanCommonMapper kanbanCommonMapper;
    @Autowired
    private CustomerServiceCommonService customerServiceCommonService;
    @Autowired
    private RedisTemplate<String, Object> redisTemplate;

    @Override
    @Transactional(rollbackFor = Exception.class)
    public BaseResult insertCustomerMessage(CustomerMessageMiniProgramSaveDTO saveDto) {
        // 主体数据
        LOCAL_LOG.info("处理主体数据");
        CustomerGraphics customerGraphics = new CustomerGraphics();
        BeanUtil.copyProperties(saveDto, customerGraphics);
        customerGraphics.initOperateInfo(tokenManager.getUserIdFromToken(), ObjectUtil.isNull(saveDto.getId()));
        if (ObjectUtil.isNull(customerGraphics.getId())) {
            long id = snowflakeComponent.snowflakeId();
            customerGraphics.setId(id);
        }
//        // 设置链接数
//        if (CustomerCommonConstant.REMOTE_LINK_NEWS_TYPE_LIST.contains(saveDto.getCustomerReferralDto().getNewsType())) {
//            customerGraphics.setReferralSize(1);
//        }
        super.saveOrUpdate(customerGraphics);

        // 处理活动数据
        List<ReferralEntity> list = referralEntityService.list(new QueryWrapper<ReferralEntity>().eq("material_graphics_id", customerGraphics.getId()).eq("is_deleted", 0));
        if (CollectionUtil.isNotEmpty(list)) {
            list.forEach(c->{
                BeanUtil.copyProperties(saveDto, c);
                // 获取name模板
                String nameModel = CustomerCommonConstant.getLinkNameModel(c.getNewsType());
                LOCAL_LOG.info("获取name模板: {}", nameModel);
                if (StringUtils.isNotBlank(nameModel)) {
                    c.setName(nameModel);
                }
                // 保存链接数据
                referralEntityService.saveOrUpdate(c);
            });
            return new BaseResult().success();
        }
        ReferralEntity referralEntity = new ReferralEntity();
        BeanUtil.copyProperties(saveDto, referralEntity);
        referralEntity.setMaterialGraphicsId(customerGraphics.getId());
        // 获取name模板
        String nameModel = CustomerCommonConstant.getLinkNameModel(referralEntity.getNewsType());
        LOCAL_LOG.info("获取name模板: {}", nameModel);
        if (StringUtils.isNotBlank(nameModel)) {
            referralEntity.setName(nameModel);
        }

        // 保存链接数据
        referralEntityService.saveOrUpdate(referralEntity);
        return new BaseResult().success();
    }

    @Override
    public GenericsResult<CustomerMessageMiniProgramSaveDTO> getCustomerTextDetail(Long id) {
        // 获取主体数据
        CustomerGraphics customerGraphics = super.getById(id);
        if (ObjectUtil.isNull(customerGraphics)) {
            return new GenericsResult<>(false, "找不到主体数据");
        }
        CustomerMessageMiniProgramSaveDTO miniProgramDTO = new CustomerMessageMiniProgramSaveDTO();
        BeanUtil.copyProperties(customerGraphics, miniProgramDTO);
        miniProgramDTO.setPostTime(customerGraphics.getPostTimeStr());

//         获取链接数据
        List<ReferralEntity> referralEntityList = referralEntityService.list(new QueryWrapper<ReferralEntity>().eq("material_graphics_id", id).eq("is_deleted",0).
                isNull("account_id"));

        if (CollectionUtil.isEmpty(referralEntityList)) {
            return new GenericsResult<>(false, "找不到链接数据");
        }
        ReferralEntity referralEntity = referralEntityList.get(0);
        miniProgramDTO.setMpAppId(referralEntity.getMpAppId());
        miniProgramDTO.setMpTitle(referralEntity.getMpTitle());
        miniProgramDTO.setMpPath(referralEntity.getMpPath());

        return new GenericsResult<>(miniProgramDTO);
    }

    @Override
    public void upload(Map<String, List<CrowdPackageUserVO>> storeGroupMap, CustomerGraphics customerGraphics, ReferralEntity customerReferral) {
        Map<String, String> storeEntityMap = getStoreEntityMap(storeGroupMap.keySet());

        storeGroupMap.forEach((storeType, userVoList) -> {
            LOCAL_LOG.info("当前处理书城: {}", storeType);
            // 去重提取公众号
            Set<String> accountSet = userVoList.stream().map(CrowdPackageUserVO::getAccountId).collect(Collectors.toSet());
            List<AuthInfoVO> authInfoList = customerServiceCommonService.getAuthInfoList(accountSet);

            // 定义
            List<ReferralEntity> referralEntityList = new ArrayList<>(accountSet.size());
            for (AuthInfoVO authInfoVo : authInfoList) {
                ReferralEntity referralEntity = new ReferralEntity();

                BeanUtil.copyProperties(customerReferral, referralEntity);
                // 重新生成链接主键id
                referralEntity.setId(snowflakeComponent.snowflakeId());
                referralEntity.setAccountId(authInfoVo.getAccountId());
                referralEntity.setStoreTypeName(storeEntityMap.get(storeType));
                uploadImg(referralEntity,customerGraphics.getCoverUrl(),authInfoVo.getAppId());

                referralEntityList.add(referralEntity);
            }

            // 批量新增
            referralEntityService.saveBatch(referralEntityList);
        });
    }

    private void uploadImg(ReferralEntity referralEntity, String imgUrl, String appId) {

        if (StringUtils.isBlank(imgUrl)) {
            return;
        }
        // 在这里生成新的media_id和url
        byte[] picBytes = HttpClientUtil.readInputStream(imgUrl);
        String suffix = null;
        if (imgUrl.contains(".")) {
            suffix = imgUrl.substring(imgUrl.lastIndexOf(".") + 1);
        }

        Map<String, String> wxTokenMap = new HashMap<>();
        Object tokenObj = redisTemplate.opsForHash().get("AUTH_ACCESS_TOKEN", appId);
        if (ObjectUtil.isNull(tokenObj)) {
            return;
        }
        wxTokenMap.put("access_token", tokenObj.toString());
        wxTokenMap.put("type", "image");
        String json = HttpClientUtil.uploadFileByte("https://api.weixin.qq.com" + "/cgi-bin/material/add_material", picBytes, wxTokenMap, suffix);
        JSONObject jsonObject = JSON.parseObject(json);
        if (StringUtils.isNotBlank(jsonObject.getString("errcode"))) {
            throw new BaseException(jsonObject.getString("errmsg"));
        }

        String newUrlMediaId = jsonObject.getString("media_id");
        referralEntity.setMediaId(newUrlMediaId);
    }

    private Map<String, String> getStoreEntityMap(Set<String> storeKeySet) {
        if (CollectionUtil.isEmpty(storeKeySet)) {
            return new HashMap<>(4);
        }
        List<CommonOptionResponseVO> storeTypeEntity = kanbanCommonMapper.getStoreTypeEntity(storeKeySet);
        return storeTypeEntity.stream().collect(Collectors.toMap(CommonOptionResponseVO::getKey, CommonOptionResponseVO::getName));

    }
}
