package com.yaoyaozw.customer.utils;

import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.ZoneOffset;
import java.util.Calendar;
import java.util.Date;
import java.util.Random;
import java.util.TimeZone;

/**
 * @author 10626
 */
public class YYZWDateUtil {

    private static final Log Logger = LogFactory.getLog(YYZWDateUtil.class);

    /**
     * 指定每天晚上12点过期
     *
     * @param currentTime
     * @return
     */
    public static Long cacheTime(Long currentTime) {
        Long oneDay = 86400000L;
//        60*1000L - 5*60*1000
        Long randomTime = Long.valueOf((60000 + Math.random() * (300000 - 60000 + 1)) + "");
        return currentTime + oneDay + randomTime;
    }

    /**
     * 比结束时间多5-10分钟时间
     *
     * @param date
     * @return
     */
    public static long getTime(Date date) {
        long time = date.getTime();
        long l = System.currentTimeMillis();
//        300000 -600000
        Random r = new Random();
        int v = r.nextInt(300000) + 300000;
        return time - l + v;
    }

    public static String getDate(String dateStr, int day) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        Calendar c = Calendar.getInstance();
        Date date;
        try {
            date = simpleDateFormat.parse(dateStr);
        } catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
        c.setTime(date);
        int day1 = c.get(Calendar.DATE);
        c.set(Calendar.DATE, (day1 + day) - 1);
        return simpleDateFormat.format(c.getTime());
    }

    public static String getForwardDate(String dateStr, int day) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        Calendar c = Calendar.getInstance();
        Date date;
        try {
            date = simpleDateFormat.parse(dateStr);
        } catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
        c.setTime(date);
        int day1 = c.get(Calendar.DATE);
        c.set(Calendar.DATE, (day1 - day) + 1);
        return simpleDateFormat.format(c.getTime());
    }


    public static final String DEFAULT_DATE_PATTERN = "yyyy-MM-dd HH:mm:ss";

    public static final String UTC_DATE_PATTERN = "yyyy-MM-dd'T'HH:mm:ssXXX";

    public static final String DATE_PATTERN_1 = "yyyy-MM-dd";

    public static final String DATE_PATTERN_2 = "yyyyMMddHHmm";

    public static Date formatDateStr(String date){
        if(StringUtils.isEmpty(date)){
            return null;
        }
        try {
            return DateUtils.parseDate(date, DEFAULT_DATE_PATTERN);
        } catch (ParseException e) {
            Logger.error("日期转换错误, 错误日期为" + date);
        }
        return null;
    }

    public static Date formatDateStr(String date, String format){
        if(StringUtils.isEmpty(date)){
            return null;
        }
        try {
            return DateUtils.parseDate(date, format);
        } catch (ParseException e) {
            Logger.error("日期转换错误, 错误日期为" + date);
        }
        return null;
    }

    /**
     * 转换为"yyyy-MM-dd"格式的DATE
     * @param date
     * @return
     */
    public static Date transformDate(Date date){

        DateFormat df = new SimpleDateFormat(DATE_PATTERN_1);

        try {
            return DateUtils.parseDate(df.format(date), DATE_PATTERN_1);
        } catch (ParseException e) {
            Logger.error("日期转换错误, 错误日期为" + date);
        }
        return null;
    }

    public static String formatDate(Date date){
        DateFormat df = new SimpleDateFormat(DEFAULT_DATE_PATTERN);
        return df.format(date);
    }

    public static String formatDate(Date date, String pattern){
        DateFormat df = new SimpleDateFormat(pattern);
        return df.format(date);
    }

    public static Date getDayStartTime(){
        Calendar calendar = Calendar.getInstance();
        calendar.set(Calendar.AM_PM, 0);
        calendar.set(Calendar.HOUR, 0);
        calendar.set(Calendar.MINUTE, 0);
        calendar.set(Calendar.SECOND, 0);
        calendar.set(Calendar.MILLISECOND, 0);
        return calendar.getTime();
    }

    public static Date getDayEndTime(){
        Calendar calendar = Calendar.getInstance();
        calendar.set(Calendar.AM_PM, 1);
        calendar.set(Calendar.HOUR, 11);
        calendar.set(Calendar.MINUTE, 59);
        calendar.set(Calendar.SECOND , 59);
        return calendar.getTime();
    }

    public static Date getDayStartTime(Date date){
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(Calendar.AM_PM, 0);
        calendar.set(Calendar.HOUR, 0);
        calendar.set(Calendar.MINUTE, 0);
        calendar.set(Calendar.SECOND, 0);
        calendar.set(Calendar.MILLISECOND, 0);
        return calendar.getTime();
    }

    public static Date getDayEndTime(Date date){
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(Calendar.AM_PM, 1);
        calendar.set(Calendar.HOUR, 11);
        calendar.set(Calendar.MINUTE, 59);
        calendar.set(Calendar.SECOND , 59);
        return calendar.getTime();
    }

    public static boolean isToday(Date date){
        return DateUtils.isSameDay(getDayStartTime(), date);
    }

    public static BigDecimal getDurationInHour(Date startDate, Date currentDate){
        if(startDate == null){
            startDate = getDayStartTime();
        }
        long diff = currentDate.getTime() - startDate.getTime();
        BigDecimal differentHours = BigDecimal.valueOf(diff);
        return differentHours.divide(BigDecimal.valueOf(3600000), 2, RoundingMode.HALF_UP);
    }

    public static String getCurrentDateWithFormat(){
        Calendar calendar = Calendar.getInstance();
        DateFormat df = new SimpleDateFormat(DATE_PATTERN_1);
        return df.format(calendar.getTime());
    }

    public static Date getCurrentDate(){
        Calendar calendar = Calendar.getInstance();
        return calendar.getTime();
    }

    public static String getLastDayWithFormat(){
        Calendar calendar = Calendar.getInstance();
        calendar.add(Calendar.DATE, -1);
        DateFormat df = new SimpleDateFormat(DATE_PATTERN_1);
        return df.format(calendar.getTime());
    }

    public static Date getLastStartDay(){
        Calendar calendar = Calendar.getInstance();
        calendar.set(Calendar.AM_PM, 0);
        calendar.set(Calendar.HOUR, 0);
        calendar.set(Calendar.MINUTE, 0);
        calendar.set(Calendar.SECOND, 0);
        calendar.set(Calendar.MILLISECOND, 0);
        calendar.add(Calendar.DATE, -1);
        return calendar.getTime();
    }

    public static Date getLastEndDay(){
        Calendar calendar = Calendar.getInstance();
        calendar.set(Calendar.AM_PM, 1);
        calendar.set(Calendar.HOUR, 11);
        calendar.set(Calendar.MINUTE, 59);
        calendar.set(Calendar.SECOND , 59);
        calendar.add(Calendar.DATE, -1);
        return calendar.getTime();
    }

    public static Date getLastStartDay(Date date){
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(Calendar.AM_PM, 0);
        calendar.set(Calendar.HOUR, 0);
        calendar.set(Calendar.MINUTE, 0);
        calendar.set(Calendar.SECOND, 0);
        calendar.set(Calendar.MILLISECOND, 0);
        calendar.add(Calendar.DATE, -1);
        return calendar.getTime();
    }

    public static Date getLastEndDay(Date date){
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(Calendar.AM_PM, 1);
        calendar.set(Calendar.HOUR, 11);
        calendar.set(Calendar.MINUTE, 59);
        calendar.set(Calendar.SECOND , 59);
        calendar.add(Calendar.DATE, -1);
        return calendar.getTime();
    }

    /**
     * 返回今天0点的UTC时间格式
     * 2021-05-24T00:00:00UTC
     * @return
     */
    public static String getUTCDayStartTime(){
        Calendar calendar = Calendar.getInstance();
        calendar.set(Calendar.AM_PM, 0);
        calendar.set(Calendar.HOUR, 8);
        calendar.set(Calendar.MINUTE, 0);
        calendar.set(Calendar.SECOND, 0);
        DateFormat df = new SimpleDateFormat(UTC_DATE_PATTERN);
        df.setTimeZone(TimeZone.getTimeZone(ZoneOffset.UTC));
        String date = df.format(calendar.getTime());
        return date;
    }

    /**
     * 返回今天23点59分59秒的UTC时间格式
     * 2021-05-24T23:59:59UTC
     * @return
     */
    public static String getUTCDayEndTime(){
        Calendar calendar = Calendar.getInstance();
        calendar.set(Calendar.AM_PM, 1);
        calendar.set(Calendar.HOUR, 19);
        calendar.set(Calendar.MINUTE, 59);
        calendar.set(Calendar.SECOND, 59);
        DateFormat df = new SimpleDateFormat(UTC_DATE_PATTERN);
        df.setTimeZone(TimeZone.getTimeZone(ZoneOffset.UTC));
        String date = df.format(calendar.getTime());
        return date;
    }

    /**
     * 返回今天0点的UTC时间格式
     * 2021-05-24T00:00:00UTC
     * @return
     */
    public static String getUTCLastDayStartTime(){
        Calendar calendar = Calendar.getInstance();
        calendar.set(Calendar.AM_PM, 0);
        calendar.set(Calendar.HOUR, 8);
        calendar.set(Calendar.MINUTE, 0);
        calendar.set(Calendar.SECOND, 0);
        calendar.add(Calendar.DATE, -1);
        DateFormat df = new SimpleDateFormat(UTC_DATE_PATTERN);
        df.setTimeZone(TimeZone.getTimeZone(ZoneOffset.UTC));
        String date = df.format(calendar.getTime());
        return date;
    }

    /**
     * 返回今天23点59分59秒的UTC时间格式
     * 2021-05-24T23:59:59UTC
     * @return
     */
    public static String getUTCLastDayEndTime(){
        Calendar calendar = Calendar.getInstance();
        calendar.set(Calendar.AM_PM, 1);
        calendar.set(Calendar.HOUR, 19);
        calendar.set(Calendar.MINUTE, 59);
        calendar.set(Calendar.SECOND, 59);
        calendar.add(Calendar.DATE, -1);
        DateFormat df = new SimpleDateFormat(UTC_DATE_PATTERN);
        df.setTimeZone(TimeZone.getTimeZone(ZoneOffset.UTC));
        String date = df.format(calendar.getTime());
        return date;
    }

    /**
     * 返回昨天0点的时间戳
     * @return
     */
    public static String getLastDayStartTimeStamp(){
        Calendar calendar = Calendar.getInstance();
        calendar.set(Calendar.AM_PM, 0);
        calendar.set(Calendar.HOUR, 0);
        calendar.set(Calendar.MINUTE, 0);
        calendar.set(Calendar.SECOND, 0);
        calendar.add(Calendar.DATE, -1);
        String stamp=calendar.getTimeInMillis()/1000 + "";
        return stamp;
    }

    /**
     * 返回昨天23:59:59点的时间戳
     * @return
     */
    public static String getLastDayEndTimeStamp(){
        Calendar calendar = Calendar.getInstance();
        calendar.set(Calendar.AM_PM, 1);
        calendar.set(Calendar.HOUR, 11);
        calendar.set(Calendar.MINUTE, 59);
        calendar.set(Calendar.SECOND, 59);
        calendar.add(Calendar.DATE, -1);
        String stamp=calendar.getTimeInMillis()/1000 + "";
        return stamp;
    }
    /**
     * 返回昨天0点，格式 yyyyMMddHHmm
     */
    public static String getLastDayStart_WY(){
        Calendar calendar = Calendar.getInstance();
        calendar.set(Calendar.AM_PM, 0);
        calendar.set(Calendar.HOUR, 0);
        calendar.set(Calendar.MINUTE, 0);
        calendar.set(Calendar.SECOND, 0);
        calendar.add(Calendar.DATE, -1);
        DateFormat df = new SimpleDateFormat(DATE_PATTERN_2);
        String date = df.format(calendar.getTime());
        return date;
    }

    /**
     * 返回昨天23:59:59，格式 yyyyMMddHHmm
     */
    public static String getLastDayEnd_WY(){
        Calendar calendar = Calendar.getInstance();
        calendar.set(Calendar.AM_PM, 1);
        calendar.set(Calendar.HOUR, 11);
        calendar.set(Calendar.MINUTE, 59);
        calendar.set(Calendar.SECOND, 59);
        calendar.add(Calendar.DATE, -1);
        DateFormat df = new SimpleDateFormat(DATE_PATTERN_2);
        String date = df.format(calendar.getTime());
        return date;
    }
    /**
     * 获取当前时间到下一分钟的时间差
     * @return different - 时间差
     */
    public static long getDateDiffBetweenCurrentWithNextMin(){
        Calendar calendar = Calendar.getInstance();
        Date currentDate = calendar.getTime();
        calendar.add(Calendar.MINUTE, 1);
        calendar.set(Calendar.SECOND, 0);
        Date nextMin = calendar.getTime();
        long different = nextMin.getTime() - currentDate.getTime();
        return different;
    }

    /**
     * 计算两个日期相差天数
     * @return 相差天数
     */
    public static int getDaysBetweenTwoDates(Date start, Date end){
        int betweenDays = (int)((end.getTime() - start.getTime()) / (1000L*3600L*24));
        return betweenDays;
    }

    /**
     * 日期加N天
     * @return 日期+N天
     */
    public static Date addNumberDays(Date date, int i){
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(Calendar.DATE, i);
        return calendar.getTime();
    }
    /**
     * 日期减N天
     */
    public static Date subtractNumberDays(Date date, int i){
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(Calendar.DATE, -i);
        return calendar.getTime();
    }

    public static boolean isSameDate(Date date1, Date date2){
        boolean result = Boolean.FALSE;
        if(date1 != null && date2 != null){
            Calendar cal1 = Calendar.getInstance();
            Calendar cal2 = Calendar.getInstance();
            cal1.setTime(date1);
            cal2.setTime(date2);
            result = cal1.get(Calendar.YEAR) == cal2.get(Calendar.YEAR) &&
                    cal1.get(Calendar.MONTH) == cal2.get(Calendar.MONTH) &&
                    cal1.get(Calendar.DAY_OF_MONTH) == cal2.get(Calendar.DAY_OF_MONTH);
        }
        return result;
    }

    public static Date getLastHourTime(Date date){
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(Calendar.HOUR,-1);
        return calendar.getTime();
    }


    /**
     * 获取当月
     */
    public static Date getMonth(Date date){

        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(Calendar.DAY_OF_MONTH,1);
        calendar.set(Calendar.AM_PM, 0);
        calendar.set(Calendar.HOUR, 0);
        calendar.set(Calendar.MINUTE, 0);
        calendar.set(Calendar.SECOND, 0);
        return calendar.getTime();
    }

}
