package com.yaoyaozw.customer.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import lombok.Data;

/**
    * 注册用户信息
    */
@Data
@TableName(value = "register_user_entity")
public class RegisterUserEntity implements Serializable {
    /**
     * 主键
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /**
     * app_id
     */
    @TableField(value = "app_id")
    private String appId;

    /**
     * openid
     */
    @TableField(value = "open_id")
    private String openId;

    /**
     * 投放信息id
     */
    @TableField(value = "setup_id")
    private Long setupId;

    /**
     * 未付费0/付费1/VIP 2
     */
    @TableField(value = "pay_type")
    private Integer payType;

    /**
     * 支付次数
     */
    @TableField(value = "pay_num")
    private Integer payNum;

    /**
     * 累充金额
     */
    @TableField(value = "pay_amount")
    private Double payAmount;

    /**
     * 近一月平均金额
     */
    @TableField(value = "avg_month")
    private Double avgMonth;

    /**
     * 最近活跃时间
     */
    @TableField(value = "last_active")
    private Date lastActive;

    /**
     * 首次活跃时间
     */
    @TableField(value = "first_active")
    private Date firstActive;

    /**
     * 创建时间
     */
    @TableField(value = "gmt_create")
    private Date gmtCreate;

    /**
     * 延时客服序列
     */
    @TableField(value = "customer_sort")
    private Integer customerSort;

    /**
     * 延时客服发送时间
     */
    @TableField(value = "customer_publish")
    private Date customerPublish;

    /**
     * 人群包
     */
    @TableField(value = "in_package")
    private String inPackage;

    @TableField(exist = false)
    private Date formatDate;

    private static final long serialVersionUID = 1L;

    public static final String COL_ID = "id";

    public static final String COL_APP_ID = "app_id";

    public static final String COL_OPEN_ID = "open_id";

    public static final String COL_SETUP_ID = "setup_id";

    public static final String COL_PAY_TYPE = "pay_type";

    public static final String COL_PAY_NUM = "pay_num";

    public static final String COL_PAY_AMOUNT = "pay_amount";

    public static final String COL_AVG_MONTH = "avg_month";

    public static final String COL_LAST_ACTIVE = "last_active";

    public static final String COL_GMT_CREATE = "gmt_create";


}