package com.yaoyaozw.customer.scheduling;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.yaoyaozw.customer.constants.CustomerCommonConstant;
import com.yaoyaozw.customer.dto.integration.IntegrationRequestDTO;
import com.yaoyaozw.customer.entity.CustomerGraphics;
import com.yaoyaozw.customer.service.*;
import com.yaoyaozw.customer.entity.CrowdPackage;
import com.yaoyaozw.customer.service.AccountOrderService;
import com.yaoyaozw.customer.service.RegisterUserEntityService;
import com.yaoyaozw.customer.service.impl.CrowdPackageServiceImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;

@Component
public class SchedulingTask {

    private final static Logger localLog = LoggerFactory.getLogger(SchedulingTask.class);

    @Autowired
    private AccountOrderService accountOrderService;

    @Autowired
    private CustomerGraphicsService customerGraphicsService;

    @Autowired
    private CustomerDelayPublishService customerDelayPublishService;

    @Autowired
    private CrowdPackageServiceImpl crowdPackageService;


    /**
     * 拉取付费订单(每15min一次)
     */
    @Scheduled(cron = "0 5/15 * * * *")
    public void retrieveOrderData(){

        Calendar calendar = Calendar.getInstance();

        calendar.set(Calendar.SECOND, 0);

        calendar.set(Calendar.MILLISECOND, 0);

        IntegrationRequestDTO integrationRequestDTO = new IntegrationRequestDTO();

        integrationRequestDTO.setRequestDate(calendar.getTime());

        accountOrderService.activeUserByOrder(integrationRequestDTO);
    }

    /**
     * 更新付费用户近一月平均充值(每天一次:4点10分）
     */
    @Scheduled(cron = "0 10 4 * * *")
    public void retrieveMonthOrder(){

        Calendar calendar = Calendar.getInstance();

        calendar.set(Calendar.SECOND, 0);

        calendar.set(Calendar.MILLISECOND, 0);

        IntegrationRequestDTO integrationRequestDTO = new IntegrationRequestDTO();

        integrationRequestDTO.setRequestDate(calendar.getTime());

        accountOrderService.calculateAvgMonth(integrationRequestDTO);

    }


    /**
     * 每10min扫描一次正常客服
     */
    @Scheduled(cron = "0 0/10 * * * *")
    public void publishCustomerMessage(){

        Calendar calendar = Calendar.getInstance();

        calendar.set(Calendar.SECOND, 0);

        calendar.set(Calendar.MILLISECOND, 0);

        IntegrationRequestDTO integrationRequestDTO = new IntegrationRequestDTO();

        integrationRequestDTO.setRequestDate(calendar.getTime());

        customerGraphicsService.sendCustomerMessage(integrationRequestDTO);


    }


    /**
     * 每1min扫延时客服
     */
    @Scheduled(cron = "0 0/1 * * * *")
    public void publishDelayCustomerMessage(){

        Calendar calendar = Calendar.getInstance();

        calendar.set(Calendar.SECOND, 0);

        calendar.set(Calendar.MILLISECOND, 0);

        IntegrationRequestDTO integrationRequestDTO = new IntegrationRequestDTO();

        integrationRequestDTO.setRequestDate(calendar.getTime());

        customerDelayPublishService.sendCustomerDelayMessage(integrationRequestDTO);
    }

    /**
     * 从redis中更新人群包人数
     */
    @Scheduled(cron = "0 0/15 * * * ?")
    public void updateCrowdPackageNumFromRedis() {
        crowdPackageService.updateCrowdPackageNumFromRedis();
    }
}
