package com.yaoyaozw.customer.service.wechat.service;

import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;

@Service
public class WeChatRestService {

    /**
     * POST请求
     * @param fullPath 请求路径
     * @param queryMap query
     * @param requestMap Body
     * @param urlParams 路径变量
     * @param responseEntity 返回实体
     * @param <T> 泛型
     * @return 响应结果
     * @throws RestClientException 异常
     */
    public <T> ResponseEntity<T> postRequest(String fullPath, MultiValueMap<String, String> queryMap, Map<String, Object> requestMap, Map<String,Object> urlParams, Class<T> responseEntity)
            throws RestClientException {

        RestTemplate restTemplate = new RestTemplate();

        UriComponentsBuilder uriComponentsBuilder = UriComponentsBuilder.fromHttpUrl(fullPath).queryParams(queryMap);

        UriComponents uriComponents=uriComponentsBuilder.build();

        if (urlParams!=null){

            uriComponents = uriComponentsBuilder.buildAndExpand(urlParams);
        }
        ResponseEntity<T> result = restTemplate.postForEntity(uriComponents.toUri(), requestMap, responseEntity);

        return result;

    }


    public <T> ResponseEntity<T> sendPostRequest(String fullPath, Class<T> responseEntity, Object requestEntity)
            throws URISyntaxException, RestClientException {
        RestTemplate restTemplate = new RestTemplate();
        URI uri = new URI(fullPath);
        ResponseEntity<T> result = restTemplate.postForEntity(uri, requestEntity, responseEntity);

        return result;

    }
}
