package com.yaoyaozw.customer.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.yaoyaozw.customer.dto.integration.IntegrationRequestDTO;
import com.yaoyaozw.customer.entity.AuthorizerToken;
import com.yaoyaozw.customer.service.AuthorizerTokenService;
import com.yaoyaozw.customer.service.CustomerGraphicsDelayService;
import com.yaoyaozw.customer.service.wechat.service.WeChatService;
import com.yaoyaozw.customer.vo.customer.CustomerDelayItemVO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.stream.Collectors;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.yaoyaozw.customer.entity.CustomerDelayPublish;
import com.yaoyaozw.customer.mapper.CustomerDelayPublishMapper;
import com.yaoyaozw.customer.service.CustomerDelayPublishService;

/**
 * 延时客服排期
 * @author wgh
 * @date 2022/9/28 18:51
*/
@Service
public class CustomerDelayPublishServiceImpl extends ServiceImpl<CustomerDelayPublishMapper, CustomerDelayPublish> implements CustomerDelayPublishService{


    @Autowired
    private CustomerGraphicsDelayService customerGraphicsDelayService;

    @Autowired
    private AuthorizerTokenService authorizerTokenService;

    @Autowired
    private WeChatService weChatService;



    @Override
    public void sendCustomerDelayMessage(IntegrationRequestDTO integrationRequestDTO) {

        //读取延时客服排期人
        List<CustomerDelayPublish> allPostUser = list(new QueryWrapper<CustomerDelayPublish>().eq(CustomerDelayPublish.COL_CUSTOMER_PUBLISH,integrationRequestDTO.getRequestDate()));
        //涉及的appid
        Set<String> appidSet = allPostUser.stream().map(CustomerDelayPublish::getAppId).collect(Collectors.toSet());

        if (!allPostUser.isEmpty()){
            //号-用户
            Map<String, List<CustomerDelayPublish>> userMap = allPostUser.stream().collect(Collectors.groupingBy(CustomerDelayPublish::getAppId));

            List<CustomerDelayItemVO> allDelayCustomerMessage = customerGraphicsDelayService.findAllDelayCustomerMessage(appidSet,null);
/*
            List<AuthorizerToken> tokenList = authorizerTokenService.list();
            Map<String, String> tokenMap = tokenList.stream().collect(Collectors.toMap(AuthorizerToken::getAuthorizerAppid, AuthorizerToken::getAuthorizerAccessToken));
*/
            if (allDelayCustomerMessage!=null&&!allDelayCustomerMessage.isEmpty()){

                List<Future<CustomerDelayPublish>>futureList =new ArrayList<>();
                //号-发送序列-客服id
                Map<String, Map<Integer, CustomerDelayItemVO>> customerMap =
                        allDelayCustomerMessage.stream().collect(Collectors.groupingBy(CustomerDelayItemVO::getAppId,
                        Collectors.toMap(CustomerDelayItemVO::getPostSort, a -> a, (v1, v2) -> v2)));

                for (Map.Entry<String,  List<CustomerDelayPublish>> userEntry : userMap.entrySet()) {

                    String appid = userEntry.getKey();

                    AuthorizerToken authorizerToken = authorizerTokenService.findTokenByAppid(appid);

                    String token = authorizerToken.getAuthorizerAppid();
                    //没token过滤
                    if (token==null||"".equals(token)){ continue; }
                    //该号下延时客服
                    Map<Integer,CustomerDelayItemVO> delaySortMap = customerMap.get(appid);
                    //所有的用户
                    List<CustomerDelayPublish> userList = userEntry.getValue();

                    if (delaySortMap!=null&&!delaySortMap.isEmpty()){

                        for (CustomerDelayPublish userPublish : userList) {
                            //发送客服
                            futureList.add(weChatService.sendCustomerDelayMessage(token, userPublish, delaySortMap)) ;
                        }
                    }
                }
                List<CustomerDelayPublish> registerUserEntities = new ArrayList<>();
                //更新下次延时排期
                for (Future<CustomerDelayPublish> delayPublishFuture : futureList) {
                    try {
                        registerUserEntities.add(delayPublishFuture.get()) ;

                    } catch (InterruptedException | ExecutionException e) {
                        e.printStackTrace();
                    }
                }
                updateBatchById(registerUserEntities);
            }

        }
    }
}
