package com.yaoyaozw.customer.service.wechat.entity.customerRequest;

import lombok.Data;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/**
 * @author wgh
 * @date 2022/10/8 19:04
 */

@Data
public class WeChatCustomerRequestEntity implements Serializable {

    private String touser;

    private String msgtype;

    private CustomerNewsItem news;

    private CustomerTextItem text;

    private CustomerMiniProgram miniprogrampage;

    public WeChatCustomerRequestEntity( String msgtype, String title, String description, String url, String picurl) {

        this.msgtype = msgtype;
        this.news = new CustomerNewsItem(new CustomerNewsArticleItem(title,description,url,picurl));
    }

    public WeChatCustomerRequestEntity(String msgtype, String content) {

        this.msgtype = msgtype;
        this.text = new CustomerTextItem(content);
    }

    public WeChatCustomerRequestEntity(String msgtype, String mpTitle,String mpAppId,String mpPath,String mediaId,String id) {

        this.msgtype = msgtype;
        this.miniprogrampage = new CustomerMiniProgram(mpTitle,mpAppId,mpPath,mediaId);
    }


    public WeChatCustomerRequestEntity() {
    }
}
