package com.yaoyaozw.customer.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.yaoyaozw.customer.common.BaseResult;
import com.yaoyaozw.customer.common.GenericsResult;
import com.yaoyaozw.customer.dto.customer.CustomerMessageMiniProgramSaveDTO;
import com.yaoyaozw.customer.dto.customer.CustomerMessageTextSaveDTO;
import com.yaoyaozw.customer.entity.CustomerGraphics;
import com.yaoyaozw.customer.entity.ReferralEntity;
import com.yaoyaozw.customer.vo.customer.CrowdPackageUserVO;

import java.util.List;
import java.util.Map;

public interface CustomerGraphicsMiniProgramService extends IService<CustomerGraphics> {
    /**
     * 新增小程序客服消息
     * @param saveDto
     * @return
     */
    BaseResult insertCustomerMessage(CustomerMessageMiniProgramSaveDTO saveDto);

    /**
     * 获取详情
     * @param id
     * @return
     */
    GenericsResult<CustomerMessageMiniProgramSaveDTO> getCustomerTextDetail(Long id);

    /**
     * 生成链接
     * @param storeGroupMap
     * @param customerGraphics
     * @param referralEntity
     */
    void upload(Map<String, List<CrowdPackageUserVO>> storeGroupMap, CustomerGraphics customerGraphics, ReferralEntity referralEntity);
}
