package com.yaoyaozw.customer.controller;

import com.yaoyaozw.customer.annotations.OperateLog;
import com.yaoyaozw.customer.common.BaseResult;
import com.yaoyaozw.customer.common.GenericsResult;
import com.yaoyaozw.customer.dto.customer.CustomerMessageMiniProgramSaveDTO;
import com.yaoyaozw.customer.dto.customer.CustomerMessageTextSaveDTO;
import com.yaoyaozw.customer.entity.CommonReferralBody;
import com.yaoyaozw.customer.service.CustomerGraphicsMiniProgramService;
import com.yaoyaozw.customer.service.CustomerGraphicsTextService;
import com.yaoyaozw.customer.vo.customer.CustomerMessageTextDetailVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

/**
 * @author Luy
 * @date 2024/8/6 11:13
 */
@Api(tags = "客服消息接口-小程序")
@RestController
@RequestMapping("/customer-service/message/miniProgram")
public class CustomerMessageMiniProgramController {

    @Autowired
    private CustomerGraphicsMiniProgramService miniProgramService;


    @ApiOperation("新增客服主体")
    @PostMapping("/insertCustomerMessage")
    @OperateLog(module = "客服消息-小程序", desc = "新增小程序客服消息")
    public BaseResult insertCustomerMessage(@RequestBody CustomerMessageMiniProgramSaveDTO saveDto) {
        return miniProgramService.insertCustomerMessage(saveDto);
    }

    @ApiOperation("获取文本客服详情")
    @GetMapping("/detail/{id}")
    public GenericsResult<CustomerMessageMiniProgramSaveDTO> getCustomerTextDetail(@PathVariable("id") Long id) {
        return miniProgramService.getCustomerTextDetail(id);
    }




}
