package com.yaoyaozw.customer.mapper;

import com.baomidou.dynamic.datasource.annotation.DS;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.yaoyaozw.customer.dto.customer.CustomerDelayQueryDTO;
import com.yaoyaozw.customer.entity.CustomerGraphicsDelay;
import com.yaoyaozw.customer.vo.AuthInfoVO;
import com.yaoyaozw.customer.vo.kanban.CommonOptionResponseVO;
import com.yaoyaozw.customer.vo.customer.CustomerDelayItemVO;
import com.yaoyaozw.customer.vo.customer.CustomerDelayListVO;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Set;


@DS("material")
@Mapper
public interface CustomerGraphicsDelayMapper extends BaseMapper<CustomerGraphicsDelay> {

    /**
     * 根据appid找有限序列的延时客服
     *
     * @param appidList
     * @param maxSort
     * @return
     */
    List<CustomerDelayItemVO> findDelayCustomerMessageByRange(@Param("appidList") Set<String> appidList, @Param("maxSort") Integer maxSort);

    void updateSendNumByVo(@Param("CustomerDelayItems") Set<CustomerDelayItemVO> voList);

    /**
     * 页面列表
     *
     * @param queryDto 查询dto
     * @return {@link List}<{@link CustomerDelayListVO}>
     */
    List<CustomerDelayListVO> pageList(@Param("queryDto") CustomerDelayQueryDTO queryDto);

    /**
     * 得到客户账户存在
     *
     * @param keyword 关键字
     * @return {@link List}<{@link AuthInfoVO}>
     */
    List<AuthInfoVO> getExistCustomerAccount(@Param("keyword") String keyword);

    /**
     * 让时间间隔列表
     *
     * @param keyword     关键词
     * @param keywordList 关键词拆分
     * @param storeType   书城
     * @param appId       需要排除的公众号appId
     * @return {@link List}<{@link AuthInfoVO}>
     */
    List<AuthInfoVO> getAuthList(@Param("keyword") String keyword, @Param("keywordList") List<String> keywordList, @Param("storeType") String storeType, @Param("appId") String appId);

    /**
     * 让时间间隔列表
     *
     * @return {@link List}<{@link CommonOptionResponseVO}>
     */
    List<CommonOptionResponseVO> getTimeIntervalList();

    /**
     * 获取延时客服主体的公众号
     *
     * @param customerId 延时客服主键
     * @return 公众号
     */
    AuthInfoVO getCustomerDelayAuthInfo(@Param("customerId") Long customerId);

    /**
     * 帐户名和物质
     *
     * @param appidList appid列表
     * @return {@link List}<{@link String}>
     */
    List<String> getAccountNameWithMaterial(@Param("appidList") List<String> appidList);

}