package com.yaoyaozw.customer.controller;

import com.yaoyaozw.customer.common.GenericsResult;
import com.yaoyaozw.customer.service.CustomerServiceCommonService;
import com.yaoyaozw.customer.vo.kanban.CommonOptionResponseVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * @author darker
 * @date 2022/10/9 10:15
 */
@RestController
@RequestMapping("/customer-service/common")
@Api(tags = "客服通用接口")
public class CustomerCommonController {

    @Autowired
    private CustomerServiceCommonService commonService;

    @GetMapping("/getStoreList")
    @ApiOperation("获取书城列表")
    public GenericsResult<List<CommonOptionResponseVO>> getStoreList() {
        return commonService.getStoreList();
    }

    @GetMapping("/getCoverPicList")
    @ApiOperation("获取书城列表")
    public GenericsResult<List<CommonOptionResponseVO>> getCoverPicList() {
        return commonService.getCoverPicList();
    }

}
