package com.yaoyaozw.customer.service.wechat.service;


import com.yaoyaozw.customer.constants.CustomerCommonConstant;
import com.yaoyaozw.customer.entity.AuthorizerToken;
import com.yaoyaozw.customer.entity.CustomerDelayPublish;
import com.yaoyaozw.customer.entity.CustomerGraphics;
import com.yaoyaozw.customer.service.ReferralEntityService;
import com.yaoyaozw.customer.service.wechat.entity.WeChatResponseEntity;
import com.yaoyaozw.customer.service.wechat.entity.customerRequest.CustomerNewsArticleItem;
import com.yaoyaozw.customer.service.wechat.entity.customerRequest.CustomerNewsItem;
import com.yaoyaozw.customer.service.wechat.entity.customerRequest.WeChatCustomerRequestEntity;
import com.yaoyaozw.customer.vo.customer.CrowdPackageUserVO;
import com.yaoyaozw.customer.vo.customer.CustomerDelayItemVO;
import com.yaoyaozw.customer.vo.referral.ReferralEntityVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.scheduling.annotation.Async;
import org.springframework.scheduling.annotation.AsyncResult;
import org.springframework.stereotype.Service;

import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.*;
import java.util.stream.Collectors;

@Service
public class WeChatServiceImpl implements WeChatService{

    private String customerPath="https://api.weixin.qq.com/cgi-bin/message/custom/send";

    private static final String CUSTOMER_TEXT="text";

    private static final String CUSTOMER_NEWS="news";

    private static final int THREAD_NUM=1000;

    private static final ThreadPoolExecutor EXECUTOR = new ThreadPoolExecutor(20, 100, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<>(2),new ThreadPoolExecutor.CallerRunsPolicy());

    private final static Object LOCK=new Object();

    @Autowired
    private WeChatRestService weChatRestService;

    @Async("myExecutor")
    @Override
    public Future<CustomerDelayPublish> sendCustomerDelayMessage(String token, CustomerDelayPublish user, Map<Integer,CustomerDelayItemVO> delaySortMap) {




        //当前时间批次发文素材的用户关注时间一致
        Long subscribeTimestamp = user.getGmtCreate().getTime();

        Integer newSort = user.getCustomerSort()+1;

        CustomerDelayItemVO customerDelayItemVO = delaySortMap.get(newSort);

        if (customerDelayItemVO!=null&&customerDelayItemVO.getTimeInterval()!=null){

            user.setCustomerSort(newSort);

            user.setCustomerPublish(new Date(subscribeTimestamp+customerDelayItemVO.getTimeInterval()));
        }
        return new AsyncResult<>(user);
    }


    @Override
    public void sendCustomerMessage(String appid, AuthorizerToken authorizerToken, CustomerGraphics customerGraphics, List<CrowdPackageUserVO> openidList, List<ReferralEntityVo> referralEntityVo) {
        //根据公众号发送客服
        String fullPath=customerPath+"?access_token="+authorizerToken.getAuthorizerAccessToken();
        //构建请求参数（文本/图文）
        WeChatCustomerRequestEntity customerRequest = buildCustomerRequest(customerGraphics,referralEntityVo);

        //计数器
        CountDownLatch latch = new CountDownLatch(openidList.size());

        if (customerRequest!=null){

            for (int i = 0; i < openidList.size(); i+=THREAD_NUM) {

                List<CrowdPackageUserVO> subOpenidList = openidList.subList(i, Math.min(i + THREAD_NUM, openidList.size()));
                //TODO:配置多线程+测试+记录发送量
                EXECUTOR.execute(()->{

                    for (CrowdPackageUserVO crowdPackageUserVO : subOpenidList) {
                        //遍历人群包，每个用户一发
                        customerRequest.setTouser(crowdPackageUserVO.getOpenId());

                        try {
                            System.err.println(customerRequest.getTouser());

                            WeChatResponseEntity response=(WeChatResponseEntity)weChatRestService.httpPostRequest(fullPath,  customerRequest,WeChatResponseEntity.class);
                            //线程锁
                            synchronized (LOCK){
                                customerGraphics.updateCount();
                            }
                            System.err.println(response);

                        } catch (Exception e) {

                            e.printStackTrace();
                        }finally {
                            latch.countDown();
                        }
                    }
                });
            }
        }
    }



    private WeChatCustomerRequestEntity buildCustomerRequest(CustomerGraphics customerGraphics,List<ReferralEntityVo> urlList){
        //类型判断
        if (CUSTOMER_TEXT.equals(customerGraphics.getType())){
            //文本类客服，需要判断替换链接的个数
            Map<Integer, String> sortReferral = urlList.stream().collect(Collectors.toMap(ReferralEntityVo::getSort, ReferralEntityVo::getReferral, (v1, v2) -> v2));

            if (customerGraphics.getReferralSize()!=null&&customerGraphics.getReferralSize().equals(sortReferral.size())){

                String content = customerGraphics.getContent();

                for (Map.Entry<Integer, String> replaceReferral : sortReferral.entrySet()) {

                    Integer sort = replaceReferral.getKey();

                    String url = replaceReferral.getValue();
                    //替换占位符
                    content=content.replace(CustomerCommonConstant.CUSTOMER_TEXT_URL_PLACEHOLDER + sort, url);
                }
                return new WeChatCustomerRequestEntity(CUSTOMER_TEXT,content);

            }else{

                return null;
            }
        }else if (CUSTOMER_NEWS.equals(customerGraphics.getType())){

            return new WeChatCustomerRequestEntity(CUSTOMER_NEWS,customerGraphics.getExtendTitle(),customerGraphics.getContent(),urlList.get(0).getReferral(),customerGraphics.getCoverUrl());
        }
        return null;
    }
}
