package com.yaoyaozw.customer.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import java.io.Serializable;
import java.util.Date;
import lombok.Data;

/**
* @author wgh
* @date 2022/9/28 18:51
*/

@Data
@TableName(value = "register_user_entity")
public class CustomerDelayPublish implements Serializable {
    /**
     * 主键
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /**
     * app_id
     */
    @TableField(exist = false ,value = "app_id")
    private String appId;

    /**
     * openid
     */
    @TableField(exist = false ,value = "open_id")
    private String openId;

    /**
     * 未付费0/付费1/VIP 2
     */
    @TableField(exist = false ,value= "pay_type")
    private Byte payType;

    /**
     * 延时客服序列
     */
    @TableField(value = "customer_sort")
    private Integer customerSort;

    /**
     * 延时客服发送时间
     */
    @TableField(value = "customer_publish")
    private Date customerPublish;

    /**
     * 创建时间
     */
    @TableField(exist = false ,value = "gmt_create")
    private Date gmtCreate;


    private static final long serialVersionUID = 1L;

    public static final String COL_ID = "id";

    public static final String COL_APP_ID = "app_id";

    public static final String COL_OPEN_ID = "open_id";

    public static final String COL_PAY_TYPE = "pay_type";

    public static final String COL_CUSTOMER_SORT = "customer_sort";

    public static final String COL_CUSTOMER_PUBLISH = "customer_publish";

    public static final String COL_GMT_CREATE = "gmt_create";
}