package com.yaoyaozw.customer.controller;

import com.yaoyaozw.customer.common.BaseResult;
import com.yaoyaozw.customer.common.GenericsResult;
import com.yaoyaozw.customer.dto.crowd.CrowdPackageQueryDTO;
import com.yaoyaozw.customer.dto.crowd.CrowdPackageSaveDTO;
import com.yaoyaozw.customer.security.TokenManager;
import com.yaoyaozw.customer.service.CrowdPackageService;
import com.yaoyaozw.customer.vo.crowd.CrowdPackageListVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.ArrayList;
import java.util.List;

/**
 * @author darker
 * @date 2022/9/15 14:08
 */
@Api(tags = "人群包接口")
@RestController
@RequestMapping("/crowd-package")
public class CrowdPackageController {

    @Autowired
    private CrowdPackageService crowdPackageService;


    @ApiOperation("保存")
    @PostMapping("/save")
    public BaseResult saveCrowdPackage(@RequestBody CrowdPackageSaveDTO saveDto) {
        return new BaseResult().success();
    }

    @ApiOperation("编辑")
    @PostMapping("/edit")
    public BaseResult updateCrowdPackage(@RequestBody CrowdPackageSaveDTO saveDto) {
        return new BaseResult().success();
    }

    @ApiOperation("查询")
    @PostMapping("/pageList")
    public GenericsResult<List<CrowdPackageListVO>> pageList(@RequestBody CrowdPackageQueryDTO queryDto) {
        return new GenericsResult<>(new ArrayList<>());
    }

    @ApiOperation("删除")
    @GetMapping("/remove/{id}")
    public BaseResult removeCrowdPackage(@PathVariable("id") Long id) {
        return new BaseResult().success();
    }



}
