package com.yaoyaozw.customer.entity;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

import com.baomidou.mybatisplus.annotation.*;
import lombok.Data;
import org.springframework.data.annotation.Id;

/**
 * 客户跟进回复
 *
 * @author darker
 * @date 2023/03/14
 */
@Data
@TableName("customer_follow_reply")
public class CustomerFollowReply implements Serializable {
    /**
     * 主键id
     */
    @Id
    @TableId(value = "id", type = IdType.ID_WORKER)
    private Long id;

    /**
     * 公众号appid
     */
    @TableField("appid")
    private String appid;

    /**
     * 素材名称
     */
    @TableField("name")
    private String name;

    /**
     * 类型
     */
    @TableField("type")
    private String type;

    /**
     * 图片/音频 原文件地址
     */
    @TableField("origin_media_url")
    private String originMediaUrl;

    /**
     * 图片/音频 腾讯后台地址
     */
    @TableField("tx_media_url")
    private String txMediaUrl;

    /**
     * 图片/音频 腾讯后台标识
     */
    @TableField("tx_media_id")
    private String txMediaId;

    /**
     * 图文-推广标题
     */
    @TableField("extend_title")
    private String extendTitle;

    /**
     * 图文-推广描述
     */
    @TableField("extend_desc")
    private String extendDesc;

    /**
     * 图文链接地址
     */
    @TableField("source_url")
    private String sourceUrl;

    /**
     * 文本-H5
     */
    @TableField("content")
    private String content;

    /**
     * 小程序标题
     */
    @TableField("mp_title")
    private String mpTitle;

    /**
     * 小程序appId
     */
    @TableField("mp_app_id")
    private String mpAppId;

    /**
     * 小程序跳转路径
     */
    @TableField("mp_path")
    private String mpPath;

    /**
     * 发文排序
     */
    @TableField("sort")
    private Integer sort;

    /**
     * 状态
     */
    @TableField("status")
    private Integer status;

    /**
     * 逻辑删除
     */
    @TableField(value = "is_deleted", fill = FieldFill.INSERT)
    @TableLogic
    private Integer isDeleted;

    /**
     * 创建人
     */
    @TableField(value = "create_user", fill = FieldFill.INSERT)
    private Long createUser;

    /**
     * 创建时间
     */
    @TableField(value = "gmt_create", fill = FieldFill.INSERT)
    private Date gmtCreate;

    /**
     * 更新人
     */
    @TableField(value = "modified_user", fill = FieldFill.INSERT_UPDATE)
    private Long modifiedUser;

    /**
     * 更新时间
     */
    @TableField(value = "gmt_modified", fill = FieldFill.INSERT_UPDATE)
    private Date gmtModified;

    @TableField(exist = false)
    private List<ReferralEntity> referralEntityList;
    @TableField(exist = false)
    private List<CustomerFollowReplyMultiNews> multiNewsList;

    private static final long serialVersionUID = 1L;
}

