package com.yaoyaozw.customer.controller;

import com.yaoyaozw.customer.common.BaseResult;
import com.yaoyaozw.customer.common.GenericsResult;
import com.yaoyaozw.customer.dto.crowd.CrowdPackageQueryDTO;
import com.yaoyaozw.customer.dto.crowd.CrowdPackageConditionDTO;
import com.yaoyaozw.customer.service.CrowdPackageService;
import com.yaoyaozw.customer.vo.crowd.*;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.math.BigDecimal;
import java.util.List;

/**
 * @author darker
 * @date 2022/9/15 14:08
 */
@Api(tags = "人群包接口")
@RestController
@RequestMapping("/crowd-package")
public class CrowdPackageController {

    @Autowired
    private CrowdPackageService crowdPackageService;


    @ApiOperation("新增人群包")
    @GetMapping("/insertPackage")
    public GenericsResult<CrowdPackageCommonIdVO> insertCrowdPackage(@RequestParam(required = false) Long id,
                                                                     @RequestParam(required = false) String name,
                                                                     @RequestParam(required = false) Double activeTimeMin,
                                                                     @RequestParam(required = false) Double activeTimeMax) {
        return crowdPackageService.insertCrowdPackage(id, name, activeTimeMin, activeTimeMax);
    }

    @ApiOperation("向人群包内新增条件")
    @PostMapping("/insertCondition")
    public GenericsResult<CrowdPackageCommonIdVO> insertCondition(@RequestBody CrowdPackageConditionDTO conditionDto) {
        return crowdPackageService.insertConditionIntoPackage(conditionDto);
    }

    @ApiOperation("查询")
    @PostMapping("/pageList")
    public GenericsResult<List<CrowdPackageListVO>> pageList(@RequestBody CrowdPackageQueryDTO queryDto) {
        return crowdPackageService.pageList(queryDto);
    }

    @ApiOperation("删除人群包")
    @GetMapping("/removePackage/{id}")
    public BaseResult removeCrowdPackage(@PathVariable("id") Long id) {
        return crowdPackageService.removeCrowdPackage(id);
    }

    @ApiOperation("从人群包中删除条件")
    @GetMapping("/removeCondition/{linkedId}")
    public BaseResult removeCondition(@PathVariable("linkedId") Long linkedId) {
        return crowdPackageService.removeConditionFromPackage(linkedId);
    }

    @ApiOperation("获取已配置的人群包条件")
    @GetMapping("/getPackageInfo/{id}")
    public GenericsResult<CrowdPackageDetailVO> getPackageInfo(@PathVariable("id") Long id) {
        return crowdPackageService.getPackageInfo(id);
    }

    @ApiOperation("获取所有条件下拉框")
    @GetMapping("/getAllConditions")
    public GenericsResult<List<CrowdPackageConditionVO>> getAllConditions() {
        return crowdPackageService.getAllConditions();
    }

    @ApiOperation("获取条件的可选项")
    @GetMapping("/getOptions/{conditionId}")
    public GenericsResult<ConditionOptionResponseVO> getOptions(@PathVariable("conditionId") Long conditionId) {
        return crowdPackageService.getOptions(conditionId);
    }

    @ApiOperation("更新用户列表所属的人群包")
    @GetMapping("/updateUserPackageBatch")
    public BaseResult updateUserPackageBatch(@RequestBody List<String> openIdList) {
        return crowdPackageService.updateUserPackageBatch(openIdList);
    }



}
