package com.yaoyaozw.customer.consumer;


import com.rabbitmq.client.Channel;
import com.yaoyaozw.customer.publisher.AcquisitionExceptionEventPublisher;
import org.apache.commons.lang3.StringUtils;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;

@Component
public class AcquisitionConsumer {

    @Resource
    private AcquisitionExceptionEventPublisher acquisitionExceptionEventPublisher;


    @RabbitListener(queues = "ACQUISITION_EXCEPTION", containerFactory = "acquisitionExceptionFactory")
    public void acquisitionEventConsumer(Channel channel, Message message){
        byte[] body = message.getBody();
        if (body == null) {
            return;
        }
        String bodyStr = new String(body);
        if (StringUtils.isBlank(bodyStr)) {
            return;
        }
        // 处理回调事件
        acquisitionExceptionEventPublisher.inspectAndExecute(bodyStr);
    }


}
