package com.yaoyaozw.customer.handler;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.yaoyaozw.customer.common.R;
import com.yaoyaozw.customer.constants.ApiResultConstant;
import com.yaoyaozw.customer.entity.AuthorizerExpandInfo;
import com.yaoyaozw.customer.entity.AuthorizerInfo;
import com.yaoyaozw.customer.entity.ReferralEntity;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

import java.math.BigDecimal;

import static com.yaoyaozw.customer.constants.CustomerCommonConstant.*;

/**
 * 阅文书城推广链接处理器
 *
 * @author system
 */
@Component
public class YwMpReferralHandler extends MpReferralHandler {

    @Override
    public ReferralEntity queryMpReferral(ReferralEntity referralEntity, AuthorizerInfo authorizerInfo) {
        // 处理参数：设置accountId为mpDistributorId
        referralEntity.setInfoId(authorizerInfo.getId());
        referralEntity.setAccountId(authorizerInfo.getAccountId());
        referralEntity.setAccountName(authorizerInfo.getNickName());
        if (ACTIVITY_NEWS_TYPE.equals(referralEntity.getNewsType())) {
            if (StringUtils.isBlank(referralEntity.getTemplateId())) {
                referralEntity.setTemplateId("1");
            }
            // 活动不使用小程序的分销商Id，使用公众号原分销商Id
            if (StringUtils.isBlank(referralEntity.getActivityTitle())) {
                // 构造活动标题
                String activityTitle = "";
                if (referralEntity.getRechargeAmount() != null && BigDecimal.ZERO.compareTo(referralEntity.getRechargeAmount()) != 0) {
                    activityTitle += "充" + referralEntity.getRechargeAmount().toPlainString();
                }
                if (referralEntity.getGiftAmount() != null && referralEntity.getGiftAmount() > 0) {
                    activityTitle += "送" + referralEntity.getGiftAmount() + "书币";
                }
                referralEntity.setActivityTitle(activityTitle);
            }
        }
        referralEntity.setMiniProgramQuery(Boolean.TRUE);
        // 调用接口获取原生链接
        R r = referralFeignClient.productReferral(referralEntity);
        if (!r.getCode().equals(ApiResultConstant.SUCCESS_CODE)) {
            throw new RuntimeException("获取链接失败: " + r.getMessage());
        }
        String res = r.getData("storeReferral", new TypeReference<String>() {});
        JSONObject jsonObject = JSON.parseObject(res);
        // 处理链接
        constructMpReferral(referralEntity, authorizerInfo, null, jsonObject);
        return referralEntity;
    }

    @Override
    public void constructMpReferral(ReferralEntity referralEntity, AuthorizerInfo authorizerInfo, AuthorizerExpandInfo authorizerExpandInfo, JSONObject responseJson) {
        // 原始字段
        referralEntity.setPromoteId(responseJson.getString("promoteId"));
        String referral = responseJson.getString("referral");
        referralEntity.setReferral(referral);
        // 小程序字段
        String mpPath = responseJson.getString("mpPath");
        referralEntity.setMpPath(StringUtils.isNotBlank(mpPath) ? mpPath : (isMiniProgramPath(referral) ? referral : null));
        referralEntity.setMpAppId(responseJson.getString("mpAppId"));
        referralEntity.setExtraHttpUrl(responseJson.getString("extraHttpUrl"));
    }
}

