package com.yaoyaozw.customer.controller;

import com.yaoyaozw.customer.annotations.OperateLog;
import com.yaoyaozw.customer.common.GenericsResult;
import com.yaoyaozw.customer.dto.customer.CustomerDelayTextSaveDTO;
import com.yaoyaozw.customer.dto.customer.CustomerReferralDTO;
import com.yaoyaozw.customer.service.CustomerDelayTextService;
import com.yaoyaozw.customer.vo.customer.CustomerDelayTextDetailVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

/**
 * @author darker
 * @date 2022/9/15 11:13
 */
@Api(tags = "延时客服接口-文本")
@RestController
@RequestMapping("/customer-service/delay/text")
public class CustomerDelayTextController {

    @Autowired
    private CustomerDelayTextService textService;

    @ApiOperation("新增客服主体")
    @PostMapping("/insertCustomerDelay")
    @OperateLog(desc = "新增文本延时客服")
    public GenericsResult<String> insertCustomerDelay(@RequestBody CustomerDelayTextSaveDTO saveDto) {
        return textService.insertCustomerDelay(saveDto);
    }

    @ApiOperation("新增客服内容")
    @PostMapping("/insertCustomerContent")
    @OperateLog(desc = "新增文本延时客服子素材")
    public GenericsResult<CustomerDelayTextDetailVO> insertCustomerContent(@RequestBody CustomerReferralDTO referralDto) {
        return textService.insertCustomerContent(referralDto);
    }

    @ApiOperation("获取文本客服详情")
    @GetMapping("/detail/{id}")
    public GenericsResult<CustomerDelayTextDetailVO> getCustomerTextDetail(@PathVariable("id") Long id) {
        return textService.getCustomerTextDetail(id);
    }

    @ApiOperation("删除单条文本内容")
    @GetMapping("/removeCustomerContent/{contentId}")
    @OperateLog(desc = "删除文本延时客服子素材")
    public GenericsResult<CustomerDelayTextDetailVO> removeCustomerContent(@PathVariable("contentId") Long contentId) {
        return textService.removeCustomerContent(contentId);
    }



}
