package com.yaoyaozw.customer.service.impl;

import cn.hutool.core.bean.BeanUtil;
import com.yaoyaozw.customer.common.BaseResult;
import com.yaoyaozw.customer.common.GenericsResult;
import com.yaoyaozw.customer.components.CustomerServiceCommonAsyncComponent;
import com.yaoyaozw.customer.components.TokenManager;
import com.yaoyaozw.customer.constants.CustomerCommonConstant;
import com.yaoyaozw.customer.dto.customer.CustomerMessageQueryDTO;
import com.yaoyaozw.customer.dto.customer.CustomerMessageSaveDTO;
import com.yaoyaozw.customer.entity.ReferralEntity;
import com.yaoyaozw.customer.service.CrowdPackageConditionMatchService;
import com.yaoyaozw.customer.service.ReferralEntityService;
import com.yaoyaozw.customer.service.RegisterUserEntityService;
import com.yaoyaozw.customer.vo.customer.CrowdPackageUserVO;
import com.yaoyaozw.customer.vo.customer.CustomerMessageListVO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.List;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.yaoyaozw.customer.entity.CustomerGraphics;
import com.yaoyaozw.customer.mapper.CustomerGraphicsMapper;
import com.yaoyaozw.customer.service.CustomerGraphicsService;

/**
 * 客户图形服务impl
 *
 * @author Admin
 * @date 2022/09/28
 */
@Service
public class CustomerGraphicsServiceImpl extends ServiceImpl<CustomerGraphicsMapper, CustomerGraphics> implements CustomerGraphicsService {

    private final static Logger LOCAL_LOG = LoggerFactory.getLogger(CustomerGraphicsServiceImpl.class);

    @Autowired
    private CrowdPackageConditionMatchService matchService;
    @Autowired
    private TokenManager tokenManager;
    @Autowired
    private CustomerServiceCommonAsyncComponent commonAsyncComponent;
    @Autowired
    private ReferralEntityService referralEntityService;

    @Override
    public BaseResult insertCustomerMessage(CustomerMessageSaveDTO saveDto) {

        // 主体数据
        LOCAL_LOG.info("处理主体数据");
        CustomerGraphics customerGraphics = new CustomerGraphics();
        BeanUtil.copyProperties(saveDto, customerGraphics);
        customerGraphics.initOperateInfo(tokenManager.getUserIdFromToken(), true);
        super.save(customerGraphics);

        // 处理活动数据
        ReferralEntity referralEntity = new ReferralEntity();
        BeanUtil.copyProperties(saveDto.getCustomerReferralDto(), referralEntity);
        referralEntity.setMaterialGraphicsId(customerGraphics.getId());

        referralEntityService.save(referralEntity);



        return new BaseResult().success();
    }

    @Override
    public BaseResult updateCustomerMessage(CustomerMessageSaveDTO saveDto) {
        return null;
    }

    @Override
    public GenericsResult<List<CustomerMessageListVO>> pageList(CustomerMessageQueryDTO queryDto) {
        return null;
    }

    @Override
    public BaseResult removeCustomerMessage(Long id) {
        return null;
    }
}

