package com.yaoyaozw.customer.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.yaoyaozw.customer.dto.integration.IntegrationRequestDTO;
import com.yaoyaozw.customer.entity.AuthorizerToken;
import com.yaoyaozw.customer.service.AuthorizerTokenService;
import com.yaoyaozw.customer.service.CustomerGraphicsDelayService;
import com.yaoyaozw.customer.service.CustomerGraphicsService;
import com.yaoyaozw.customer.vo.customer.DelayCustomerItemVO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.yaoyaozw.customer.mapper.RegisterUserEntityMapper;
import com.yaoyaozw.customer.entity.RegisterUserEntity;
import com.yaoyaozw.customer.service.RegisterUserEntityService;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;


@Service
public class RegisterUserEntityServiceImpl extends ServiceImpl<RegisterUserEntityMapper, RegisterUserEntity> implements RegisterUserEntityService{

    @Autowired
    private CustomerGraphicsService customerGraphicsService;

    @Autowired
    private CustomerGraphicsDelayService customerGraphicsDelayService;

    @Autowired
    private AuthorizerTokenService authorizerTokenService;

    @Override
    public void sendCustomerMessage(IntegrationRequestDTO integrationRequestDTO) {

        //1.读取人群包
        List<RegisterUserEntity> list = list();

        //2.发送客服消息



    }

    @Override
    public void sendCustomerDelayMessage(IntegrationRequestDTO integrationRequestDTO) {

        //1.读取延时客服排期人
        List<RegisterUserEntity> allPostUser = list(new QueryWrapper<RegisterUserEntity>().eq(RegisterUserEntity.COL_CUSTOMER_PUBLISH,integrationRequestDTO.getRequestDate()));
        //涉及的appid
        Set<String> appidSet = allPostUser.stream().map(RegisterUserEntity::getAppId).collect(Collectors.toSet());

        if (!allPostUser.isEmpty()){
            //号-用户
            Map<String, List<RegisterUserEntity>> userMap = allPostUser.stream().collect(Collectors.groupingBy(RegisterUserEntity::getAppId));

            List<DelayCustomerItemVO> allDelayCustomerMessage = customerGraphicsDelayService.findAllDelayCustomerMessage(appidSet);

            if (allDelayCustomerMessage!=null&&!allDelayCustomerMessage.isEmpty()){
                //号-发送序列-客服id
                Map<String, Map<Integer, List<DelayCustomerItemVO>>> customerMap = allDelayCustomerMessage.stream().collect(Collectors.groupingBy(DelayCustomerItemVO::getAppId, Collectors.groupingBy(DelayCustomerItemVO::getPostSort)));

                List<AuthorizerToken> tokenList = authorizerTokenService.list();
                //找token
                Map<String, String> tokenMap = tokenList.stream().collect(Collectors.toMap(AuthorizerToken::getAuthorizerAppid, AuthorizerToken::getAuthorizerAccessToken));

                for (Map.Entry<String,  List<RegisterUserEntity>> userEntry : userMap.entrySet()) {

                    String appid = userEntry.getKey();
                    //该号下延时客服
                    Map<Integer, List<DelayCustomerItemVO>> delaySortMap = customerMap.get(appid);
                    //所有的用户
                    List<RegisterUserEntity> userList = userEntry.getValue();

                    if (delaySortMap!=null&&!delaySortMap.isEmpty()){

                        for (RegisterUserEntity user : userList) {

                            Integer customerSort = user.getCustomerSort();


                        }
                    }


                }
            }


        }


        //2.发送延时客服

    }
}
