package com.yaoyaozw.customer.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.yaoyaozw.customer.dto.integration.IntegrationRequestDTO;
import com.yaoyaozw.customer.entity.AuthorizerToken;
import com.yaoyaozw.customer.entity.CustomerGraphics;
import com.yaoyaozw.customer.service.AuthorizerTokenService;
import com.yaoyaozw.customer.service.CustomerGraphicsDelayService;
import com.yaoyaozw.customer.service.CustomerGraphicsService;
import com.yaoyaozw.customer.vo.customer.DelayCustomerListVO;
import org.checkerframework.checker.units.qual.A;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.yaoyaozw.customer.mapper.RegisterUserEntityMapper;
import com.yaoyaozw.customer.entity.RegisterUserEntity;
import com.yaoyaozw.customer.service.RegisterUserEntityService;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;


@Service
public class RegisterUserEntityServiceImpl extends ServiceImpl<RegisterUserEntityMapper, RegisterUserEntity> implements RegisterUserEntityService{

    @Autowired
    private CustomerGraphicsService customerGraphicsService;

    @Autowired
    private CustomerGraphicsDelayService customerGraphicsDelayService;

    @Autowired
    private AuthorizerTokenService authorizerTokenService;

    @Override
    public void sendCustomerMessage(IntegrationRequestDTO integrationRequestDTO) {

        //1.读取人群包
        List<RegisterUserEntity> list = list();

        //2.发送客服消息



    }

    @Override
    public void sendCustomerDelayMessage(IntegrationRequestDTO integrationRequestDTO) {

        //1.读取延时客服排期人
        List<RegisterUserEntity> allPostUser = list(new QueryWrapper<RegisterUserEntity>().eq(RegisterUserEntity.COL_CUSTOMER_PUBLISH,integrationRequestDTO.getRequestDate()));
        //涉及的appid
        Set<String> appidSet = allPostUser.stream().map(RegisterUserEntity::getAppId).collect(Collectors.toSet());

        if (!allPostUser.isEmpty()){
            //号-发送序列-用户
            Map<String, Map<Integer, List<RegisterUserEntity>>> userMap = allPostUser.stream().collect(Collectors.groupingBy(RegisterUserEntity::getAppId, Collectors.groupingBy(RegisterUserEntity::getCustomerSort)));

            List<DelayCustomerListVO> allDelayCustomerMessage = customerGraphicsDelayService.findAllDelayCustomerMessage(appidSet);
            //号-发送序列-客服id
            Map<String, Map<Byte, List<DelayCustomerListVO>>> customerMap = allDelayCustomerMessage.stream().collect(Collectors.groupingBy(DelayCustomerListVO::getAppId, Collectors.groupingBy(DelayCustomerListVO::getPostSort)));

            //找token
            List<AuthorizerToken> tokenList = authorizerTokenService.list();
            Map<String, String> tokenMap = tokenList.stream().collect(Collectors.toMap(AuthorizerToken::getAuthorizerAppid, AuthorizerToken::getAuthorizerAccessToken));

            for (Map.Entry<String, Map<Integer, List<RegisterUserEntity>>> userEntry : userMap.entrySet()) {

                String appid = userEntry.getKey();
                Map<Byte, List<DelayCustomerListVO>> byteListMap = customerMap.get(appid);
                Map<Integer, List<RegisterUserEntity>> value = userEntry.getValue();





            }




        }


        //2.发送延时客服

    }
}
