package com.yaoyaozw.customer.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.yaoyaozw.customer.common.BaseResult;
import com.yaoyaozw.customer.common.GenericsResult;
import com.yaoyaozw.customer.components.SnowflakeComponent;
import com.yaoyaozw.customer.components.TokenManager;
import com.yaoyaozw.customer.dto.customer.CustomerDelayQueryDTO;
import com.yaoyaozw.customer.dto.customer.CustomerDelaySaveDTO;
import com.yaoyaozw.customer.entity.CustomerGraphicsDelay;
import com.yaoyaozw.customer.entity.ReferralEntity;
import com.yaoyaozw.customer.mapper.CustomerGraphicsDelayMapper;
import com.yaoyaozw.customer.service.CustomerGraphicsDelayService;
import com.yaoyaozw.customer.service.CustomerTextDelayService;
import com.yaoyaozw.customer.service.ReferralEntityService;
import com.yaoyaozw.customer.vo.AuthInfoVO;
import com.yaoyaozw.customer.vo.customer.CustomerDelayDetailVO;
import com.yaoyaozw.customer.vo.customer.CustomerDelayItemVO;
import com.yaoyaozw.customer.vo.customer.CustomerDelayListVO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Set;

/**
 * @author darker
 * @date 2022/9/15 11:13
 */
@Service
public class CustomerGraphicsDelayServiceImpl extends ServiceImpl<CustomerGraphicsDelayMapper, CustomerGraphicsDelay> implements CustomerGraphicsDelayService {

    private final static Logger localLog = LoggerFactory.getLogger(CustomerGraphicsDelayServiceImpl.class);

    @Autowired
    private TokenManager tokenManager;
    @Autowired
    private SnowflakeComponent snowflakeComponent;
    @Autowired
    private ReferralEntityService referralEntityService;


    @Override
    public List<CustomerDelayItemVO> findAllDelayCustomerMessage(Set<String> appidList,Integer maxSortRange) {

        if (maxSortRange!=null){

            return baseMapper.findDelayCustomerMessageByRange(appidList,maxSortRange);
        }else{

            return baseMapper.findAllDelayCustomerMessage(appidList);
        }
    }

    @Override
    public BaseResult insertCustomerDelay(CustomerDelaySaveDTO saveDto) {

        CustomerGraphicsDelay customerGraphicsDelay = new CustomerGraphicsDelay();
        BeanUtil.copyProperties(saveDto, customerGraphicsDelay);
        // 初始化操作信息
        customerGraphicsDelay.initOperateInfo(tokenManager.getUserIdFromToken(), ObjectUtil.isNull(saveDto.getId()));
        if (ObjectUtil.isNull(customerGraphicsDelay.getId())) {
            long id = snowflakeComponent.snowflakeId();
            localLog.info("是新增, 新生成ID: {}", id);
            customerGraphicsDelay.setId(id);
        }
        super.saveOrUpdate(customerGraphicsDelay);

        localLog.info("生成referral数据");
        ReferralEntity referralEntity = new ReferralEntity();
        referralEntity.setMaterialGraphicsId(customerGraphicsDelay.getId());
        BeanUtil.copyProperties(referralEntity, saveDto.getCustomerReferralDto());

        referralEntityService.saveOrUpdate(referralEntity);

        return new BaseResult().success();
    }

    @Override
    public GenericsResult<CustomerDelayDetailVO> getCustomerDelayDetail(Long id) {
        return null;
    }

    @Override
    public GenericsResult<PageInfo<CustomerDelayListVO>> pageList(CustomerDelayQueryDTO queryDto) {
        PageHelper.startPage(queryDto.getPageSize(), queryDto.getCurrentPage());
        List<CustomerDelayListVO> customerDelayList = super.baseMapper.pageList(queryDto);
        PageInfo<CustomerDelayListVO> pageResult = new PageInfo<>(customerDelayList);

        return new GenericsResult<>(pageResult);
    }

    @Override
    public BaseResult removeCustomerDelay(Long id) {
        return null;
    }

    @Override
    public GenericsResult<List<AuthInfoVO>> getExistCustomerAccount() {
        return null;
    }

    @Override
    public BaseResult removeBatch(List<Long> idList) {
        return null;
    }
}

