package com.yaoyaozw.customer.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.github.pagehelper.PageInfo;
import com.yaoyaozw.customer.common.BaseResult;
import com.yaoyaozw.customer.common.GenericsResult;
import com.yaoyaozw.customer.dto.customer.CustomerDelayQueryDTO;
import com.yaoyaozw.customer.dto.customer.CustomerDelaySaveDTO;
import com.yaoyaozw.customer.entity.CustomerGraphicsDelay;
import com.yaoyaozw.customer.vo.AuthInfoVO;
import com.yaoyaozw.customer.vo.customer.CustomerDelayDetailVO;
import com.yaoyaozw.customer.vo.customer.CustomerDelayItemVO;
import com.yaoyaozw.customer.vo.customer.CustomerDelayListVO;

import java.util.List;
import java.util.Set;

/**
 * @author darker
 * @date 2022/9/15 11:13
 */
public interface CustomerGraphicsDelayService extends IService<CustomerGraphicsDelay> {

    List<CustomerDelayItemVO>  findAllDelayCustomerMessage(Set<String> appidList,Integer maxSortRage);

    /**
     * 插入客户延迟
     *
     * @param saveDto 保存dto
     * @return {@link BaseResult}
     */
    BaseResult insertCustomerDelay(CustomerDelaySaveDTO saveDto);

    /**
     * 得到客户延迟细节
     *
     * @param id id
     * @return {@link GenericsResult}<{@link CustomerDelayDetailVO}>
     */
    GenericsResult<CustomerDelayDetailVO> getCustomerDelayDetail(Long id);

    /**
     * 页面列表
     *
     * @param queryDto 查询dto
     * @return {@link GenericsResult}<{@link PageInfo}<{@link CustomerDelayListVO}>>
     */
    GenericsResult<PageInfo<CustomerDelayListVO>> pageList(CustomerDelayQueryDTO queryDto);

    /**
     * 删除客户延迟
     *
     * @param id id
     * @return {@link BaseResult}
     */
    BaseResult removeCustomerDelay(Long id);

    /**
     * 得到客户账户存在
     *
     * @return {@link GenericsResult}<{@link List}<{@link AuthInfoVO}>>
     */
    GenericsResult<List<AuthInfoVO>> getExistCustomerAccount();

    /**
     * 删除批处理
     *
     * @param idList id列表
     * @return {@link BaseResult}
     */
    BaseResult removeBatch(List<Long> idList);
}

