package com.yaoyaozw.customer.dto.customer;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * @author darker
 * @date 2022/9/15 11:14
 */
@Data
@ApiModel("延时客服保存实体")
public class CustomerDelaySaveDTO implements Serializable {

    private Long id;

    private String appId;

    @ApiModelProperty("客服消息名称")
    private String name;

    @ApiModelProperty("客服消息类型(图文、文本)")
    private String type;

    @ApiModelProperty("客服消息类型(图文、文本)")
    private String extendTitle;

    @ApiModelProperty("客服消息类型(图文、文本)")
    private String coverUrl;

    @ApiModelProperty("文本内容")
    private String content;

    @ApiModelProperty("发文序号")
    private Integer postSort;

    @ApiModelProperty("发文间隔时间")
    private Long timeInterval;

    @ApiModelProperty("消息内容实体")
    private CustomerReferralDTO customerReferralDto;

}
