package com.yaoyaozw.customer.controller;

import com.github.pagehelper.PageInfo;
import com.yaoyaozw.customer.common.BaseResult;
import com.yaoyaozw.customer.common.GenericsResult;
import com.yaoyaozw.customer.dto.customer.CustomerDelayQueryDTO;
import com.yaoyaozw.customer.dto.customer.CustomerDelaySaveDTO;
import com.yaoyaozw.customer.dto.customer.CustomerDelayQueryDTO;
import com.yaoyaozw.customer.dto.customer.CustomerDelaySaveDTO;
import com.yaoyaozw.customer.service.CustomerGraphicsDelayService;
import com.yaoyaozw.customer.vo.AuthInfoVO;
import com.yaoyaozw.customer.vo.customer.CustomerDelayListVO;
import com.yaoyaozw.customer.vo.customer.CustomerDelayDetailVO;
import com.yaoyaozw.customer.vo.customer.CustomerDelayListVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.ArrayList;
import java.util.List;

/**
 * @author darker
 * @date 2022/9/15 11:13
 */
@Api(tags = "延时客服接口")
@RestController
@RequestMapping("/customer-service/delay")
public class CustomerDelayGraphicsController {

    @Autowired
    private CustomerGraphicsDelayService customerGraphicsDelayService;


    @ApiOperation("新增")
    @PostMapping("/insert")
    public BaseResult insertCustomerDelay(@RequestBody CustomerDelaySaveDTO saveDto) {
        return customerGraphicsDelayService.insertCustomerDelay(saveDto);
    }

    @ApiOperation("获取详情")
    @GetMapping("/detail/{id}")
    public GenericsResult<CustomerDelayDetailVO> getCustomerDelayDetail(@PathVariable("id") Long id) {
        return customerGraphicsDelayService.getCustomerDelayDetail(id);
    }

    @ApiOperation("查询")
    @PostMapping("/pageList")
    public GenericsResult<PageInfo<CustomerDelayListVO>> pageList(@RequestBody CustomerDelayQueryDTO queryDto) {
        return customerGraphicsDelayService.pageList(queryDto);
    }

    @ApiOperation("删除")
    @GetMapping("/remove/{id}")
    public BaseResult removeCustomerDelay(@PathVariable("id") Long id) {
        return customerGraphicsDelayService.removeCustomerDelay(id);
    }

    @ApiOperation("获取已生成客服的公众号列表")
    @GetMapping("/getExistCustomerAccount")
    public GenericsResult<List<AuthInfoVO>> getExistCustomerAccount() {
        return customerGraphicsDelayService.getExistCustomerAccount();
    }

    @ApiOperation("批量删除")
    @PostMapping("/removeBatch")
    public BaseResult removeBatch(@RequestBody List<Long> idList) {
        return customerGraphicsDelayService.removeBatch(idList);
    }

}
