package com.yaoyaozw.customer.handler;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.yaoyaozw.customer.common.R;
import com.yaoyaozw.customer.constants.ApiResultConstant;
import com.yaoyaozw.customer.entity.AuthorizerExpandInfo;
import com.yaoyaozw.customer.entity.AuthorizerInfo;
import com.yaoyaozw.customer.entity.ReferralEntity;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

/**
 * 阳光书城推广链接处理器
 *
 * @author system
 */
@Component
public class YgMpReferralHandler extends MpReferralHandler {

    @Override
    public ReferralEntity queryMpReferral(ReferralEntity referralEntity, AuthorizerInfo authorizerInfo) {
        referralEntity.setMiniProgramQuery(Boolean.TRUE);
        // 调用接口获取原生链接
        R r = referralFeignClient.productReferral(referralEntity);
        if (!r.getCode().equals(ApiResultConstant.SUCCESS_CODE)) {
            throw new RuntimeException("获取链接失败: " + r.getMessage());
        }
        String res = r.getData("storeReferral", new TypeReference<String>() {});
        JSONObject jsonObject = JSON.parseObject(res);

        // 处理链接
        constructMpReferral(referralEntity, authorizerInfo, null, jsonObject);
        return referralEntity;
    }

    @Override
    public void constructMpReferral(ReferralEntity referralEntity, AuthorizerInfo authorizerInfo, AuthorizerExpandInfo authorizerExpandInfo, JSONObject responseJson) {
        // 原始字段
        referralEntity.setPromoteId(responseJson.getString("promoteId"));
        String referral = responseJson.getString("referral");
        referralEntity.setReferral(referral);
        // 小程序字段
        String mpPath = responseJson.getString("mpPath");
        referralEntity.setMpPath(StringUtils.isNotBlank(mpPath) ? mpPath : (isMiniProgramPath(referral) ? referral : null));
        referralEntity.setMpAppId(responseJson.getString("mpAppId"));
        referralEntity.setExtraHttpUrl(responseJson.getString("extraHttpUrl"));
        if (StringUtils.isBlank(referralEntity.getMpAppId())) {
            authorizerExpandInfo = getAuthorizerExpandInfo(authorizerInfo.getAppid());
            referralEntity.setMpAppId(authorizerExpandInfo.getMpAppid());
        }
    }
}

