package com.yaoyaozw.customer.factory;

import com.yaoyaozw.customer.handler.*;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;

/**
 * 书城推广链接工厂类
 *
 * @author system
 */
@Component
public class MpReferralFactory {

    @Resource
    private TomatoMpReferralHandler tomatoMpReferralHandler;

    @Resource
    private YgMpReferralHandler ygMpReferralHandler;

    @Resource
    private YwMpReferralHandler ywMpReferralHandler;

    /**
     * 根据书城类型获取对应的Handler
     *
     * @param storeType 书城类型
     * @return 对应的Handler
     */
    public MpReferralHandler getHandler(String storeType) {
        if ("TOMATO".equals(storeType)) {
            return tomatoMpReferralHandler;
        } else if ("YANG_GUANG".equals(storeType)) {
            return ygMpReferralHandler;
        } else if ("YUE_WEN_1".equals(storeType)) {
            return ywMpReferralHandler;
        }
        throw new IllegalArgumentException("不支持的书城类型: " + storeType);
    }
}

