package com.yaoyaozw.customer.entity;

import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yaoyaozw.customer.constants.CustomerCommonConstant;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;

/**
 * 材料操作日志
 *
 * @author darker
 * @date 2022/12/09
 */
@Data
@TableName("system_operate_log")
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class SystemOperateLog implements Serializable {
    /**
     * 主键ID
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /**
     * 方法路径
     */
    @TableField("method_path")
    private String methodPath;

    /**
     * 请求参数
     */
    @TableField("request_param")
    private String requestParam;

    /**
     * 执行模块
     */
    @TableField("operate_module")
    private String operateModule;

    /**
     * 执行描述
     */
    @TableField("operate_desc")
    private String operateDesc;

    /**
     * 执行结果
     */
    @TableField("operate_result")
    private Boolean operateResult;

    /**
     * 执行时间
     */
    @TableField("operate_time")
    private Date operateTime;

    /**
     * 执行人
     */
    @TableField("operate_user")
    private Long operateUser;

    /**
     * 方法耗时
     */
    @TableField("time_cost")
    private BigDecimal timeCost;

    public Boolean getOperateResult() {
        return ObjectUtil.isNull(this.operateResult) ? Boolean.TRUE : this.operateResult;
    }

    public void setTimeCost(Long time) {
        if (ObjectUtil.isNotNull(time)) {
            this.timeCost = new BigDecimal(time).divide(CustomerCommonConstant.THOUSAND_BIG_DECIMAL, 3, RoundingMode.HALF_UP);
        }
    }

    private static final long serialVersionUID = 1L;
}

