package com.yaoyaozw.customer.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.yaoyaozw.customer.common.BaseResult;
import com.yaoyaozw.customer.common.GenericsResult;
import com.yaoyaozw.customer.dto.crowd.CrowdPackageQueryDTO;
import com.yaoyaozw.customer.dto.crowd.CrowdPackageConditionDTO;
import com.yaoyaozw.customer.entity.CrowdPackage;
import com.yaoyaozw.customer.vo.crowd.*;

import java.util.List;

/**
 * @author darker
 * @date 2022/9/16 12:03
 */
public interface CrowdPackageService extends IService<CrowdPackage> {
    /**
     * 插入人群包
     *
     * @param id 人群包id
     * @param name 人群包名
     * @return {@link BaseResult}
     */
    GenericsResult<CrowdPackageCommonIdVO> insertCrowdPackage(Long id, String name);


    /**
     * 新增人群包条件
     *
     * @param conditionDto 条件dto
     * @return {@link BaseResult}
     */
    GenericsResult<CrowdPackageCommonIdVO> insertConditionIntoPackage(CrowdPackageConditionDTO conditionDto);

    /**
     * 页面列表
     *
     * @param queryDto 查询dto
     * @return {@link GenericsResult}<{@link List}<{@link CrowdPackageListVO}>>
     */
    GenericsResult<List<CrowdPackageListVO>> pageList(CrowdPackageQueryDTO queryDto);

    /**
     * 删除群包
     *
     * @param id id
     * @return {@link BaseResult}
     */
    BaseResult removeCrowdPackage(Long id);


    /**
     * 删除条件
     *
     * @param linkedId 人群包-条件 关联主键
     * @return {@link BaseResult}
     */
    BaseResult removeConditionFromPackage(Long linkedId);


    /**
     * 得到包条件列表
     *
     * @param id id
     * @return {@link GenericsResult}<{@link List}<{@link CrowdPackageConditionVO}>>
     */
    GenericsResult<CrowdPackageDetailVO> getPackageInfo(Long id);


    /**
     * 得到所有条件
     *
     * @return {@link GenericsResult}<{@link List}<{@link CrowdPackageConditionVO}>>
     */
    GenericsResult<List<CrowdPackageConditionVO>> getAllConditions();


    /**
     * 得到某个条件的可选项
     *
     * @param conditionId 状态标识
     * @return {@link GenericsResult}<{@link ConditionOptionResponseVO}
     */
    GenericsResult<ConditionOptionResponseVO> getOptions(Long conditionId);

    /**
     * 更新用户所属人群包
     * @param openId 用户标识
     * @return 人群包id拼接
     */
    BaseResult updateUserPackageBelong(String openId);


    /**
     * 批处理更新用户包
     *
     * @param openIdList 开放id列表
     * @return {@link BaseResult}
     */
    BaseResult updateUserPackageBatch(List<String> openIdList);
}
