package com.yaoyaozw.customer.entity;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.annotation.TableField;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Date;
import java.util.List;

/**
 * @author darker
 * @date 2022/10/8 12:00
 */
@Data
public class CommonReferralBody implements Serializable {

    @ApiModelProperty("客服素材主体id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long materialGraphicsId;

    @ApiModelProperty("主键id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long id;

    @ApiModelProperty("文本类型文本内容")
    private String textContent;

    @ApiModelProperty("appId")
    private String appId;

    private Long infoId;

    @ApiModelProperty("链接类型")
    private Integer newsType;

    @ApiModelProperty("链接名")
    private String name;

    @ApiModelProperty(value="序号")
    private Integer sort;

    private String accountName;

    @ApiModelProperty(value = "渠道号")
    private String accountId;

    @ApiModelProperty("书城")
    private String storeType;

    @ApiModelProperty("书城名")
    private String storeTypeName;

    @ApiModelProperty("书")
    private String bookId;

    @ApiModelProperty("书名")
    private String bookName;

    @ApiModelProperty("章节")
    private Integer chapterIdx;

    @ApiModelProperty("推广类型")
    private Integer push;

    @ApiModelProperty("原文链接")
    private String referral;

    @ApiModelProperty("活动标题")
    private String activityTitle;

    @ApiModelProperty("限制次数")
    private Integer limited;

    @ApiModelProperty(value = "开始时间")
    private Date startTime;

    @ApiModelProperty(value = "结束时间")
    private Date endTime;

    @ApiModelProperty(value = "开始、结束时间")
    private List<Date> dateList;

    @ApiModelProperty(value = "充值金额")
    private BigDecimal rechargeAmount;

    @ApiModelProperty(value = "赠送数量")
    private Integer giftAmount;

    @ApiModelProperty(value = "模板Id")
    private String templateId;

    private String configName;

    private String configId;

    private String h5Content;

    public Date getStartTime() {
        if (ObjectUtil.isNull(this.startTime) && CollectionUtil.isNotEmpty(this.dateList)) {
            return dateList.get(0);
        }
        return startTime;
    }

    public Date getEndTime() {
        if (ObjectUtil.isNull(this.endTime) && CollectionUtil.isNotEmpty(this.dateList)) {
            return dateList.get(1);
        }
        return endTime;
    }

    public List<Date> getDateList() {
        if (CollectionUtil.isEmpty(this.dateList) && ObjectUtil.isNotNull(this.startTime) && ObjectUtil.isNotNull(this.endTime)) {
            return Arrays.asList(this.startTime, this.endTime);
        }
        return dateList;
    }

}
