package com.yaoyaozw.customer.service.impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.yaoyaozw.customer.common.BaseResult;
import com.yaoyaozw.customer.common.GenericsResult;
import com.yaoyaozw.customer.dto.DistributeDTO;
import com.yaoyaozw.customer.dto.MenuMainCopyDTO;
import com.yaoyaozw.customer.dto.follow.FollowReplyCopyDTO;
import com.yaoyaozw.customer.dto.keyword.CustomerKeywordCopyDTO;
import com.yaoyaozw.customer.entity.AccountDistributeRecord;
import com.yaoyaozw.customer.feigns.MenuFeignClient;
import com.yaoyaozw.customer.mapper.AccountDistributeLogMapper;
import com.yaoyaozw.customer.service.CustomerFollowReplyService;
import com.yaoyaozw.customer.service.CustomerGraphicsDelayService;
import com.yaoyaozw.customer.service.CustomerKeywordService;
import com.yaoyaozw.customer.service.DistributeService;
import com.yaoyaozw.customer.vo.AccountDistributeLogVO;
import com.yaoyaozw.customer.vo.AuthInfoVO;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

/**
 * @Author: Dwl
 * @Date: 2024/03/27/17:22
 * @ClassName: DistributeServiceImpl
 * @Version: V3.2.0
 * @Description:
 */
@Slf4j
@Service
public class DistributeServiceImpl extends ServiceImpl<AccountDistributeLogMapper, AccountDistributeRecord> implements DistributeService {
    @Autowired
    private CustomerGraphicsDelayService customerGraphicsDelayService;

    @Autowired
    private CustomerKeywordService keywordService;

    @Autowired
    private CustomerFollowReplyService followReplyService;

    @Autowired
    private MenuFeignClient menuFeignClient;


    @Override
    public BaseResult distribute(DistributeDTO distributeDTO) {
        List<AccountDistributeRecord> distributeLogList = new ArrayList<>();
        log.info("开始执行复用任务....");
        AuthInfoVO sourceAuth = distributeDTO.getSourceAuth();
        List<String> targetAppList = distributeDTO.getTargetAppList();
        List<AuthInfoVO> targetAuthList = distributeDTO.getTargetAuthList();
        List<Long> idList = targetAuthList.stream().map(AuthInfoVO::getId).collect(Collectors.toList());
        List<String> typeList = distributeDTO.getTypeList();

        idList.stream().forEach(c -> {
            AccountDistributeRecord distributeLog = new AccountDistributeRecord();
            distributeLog.setAuthId(distributeLog.getAuthId());
            distributeLog.setGmtCreate(new Date());
            distributeLog.setGmtModified(new Date());
            distributeLog.setTargetId(c.longValue());
            for (String type : typeList) {

                // 根据 type 的值执行不同的操作
                switch (type) {
                    case "1":
                        //关回复用
                        distributeLog.setFunctionName("1");
                        FollowReplyCopyDTO followReplyCopyDTO = new FollowReplyCopyDTO();
                        followReplyCopyDTO.setTargetAuthList(targetAuthList);
                        followReplyCopyDTO.setSourceAuth(sourceAuth);
                        //followReplyService.copy(followReplyCopyDTO);
                        break;
                    case "2":
                        //关键词复用
                        distributeLog.setFunctionName("2");
                        CustomerKeywordCopyDTO customerKeywordCopyDTO = new CustomerKeywordCopyDTO();
                        customerKeywordCopyDTO.setSourceAuth(sourceAuth);
                        customerKeywordCopyDTO.setTargetKeywordList(targetAppList);
                        customerKeywordCopyDTO.setTargetAuthList(targetAuthList);
                        //keywordService.copy(customerKeywordCopyDTO);
                        break;
                    case "3":
                        //延时客服复用
                        distributeLog.setFunctionName("3");
                        //customerGraphicsDelayService.copy(distributeDTO.getAppId(), "", "", null, targetAppList);
                        break;
                    case "4":
                        //菜单管理复用
                        distributeLog.setFunctionName("4");
                        MenuMainCopyDTO menuMainCopyDTO = new MenuMainCopyDTO();
                        menuMainCopyDTO.addList(sourceAuth.getId(), idList);
                        //menuFeignClient.copy(menuMainCopyDTO);
                        break;
                    default:
                        break;
                }
            }
            distributeLogList.add(distributeLog);
        });
        this.saveBatch(distributeLogList);

        return new BaseResult().success("复用进行中, 请等待");
    }

    @Override
    public GenericsResult<List<AccountDistributeLogVO>> logList() {
        return this.baseMapper.selectLogList();
    }
}
