package com.yaoyaozw.customer.dto;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/**
 * @author darker
 * @date 2022/11/15 16:30
 */
@Data
public class MenuMainCopyDTO implements Serializable {

    @NotNull(message = "公众号不能为空")
    @ApiModelProperty("公众号")
    private Long authId;

    @NotNull(message = "状态不能为空")
    @ApiModelProperty("是否立即启用 0-否 1-是")
    private Integer openImmediately;

    @NotNull(message = "目标公众号不能为空")
    @ApiModelProperty("复用的目标公众号ID")
    private List<Long> targetAuthList;

    @NotNull(message = "复用的菜单不能为空")
    @ApiModelProperty("要进行复用的菜单ID")
    private List<Integer> sourceMenuSortList;

    public void addList(Long authId, List<Long> targetAuthList) {
        this.authId = authId;
        this.openImmediately = 1;
        this.targetAuthList = targetAuthList;
        List<Integer> sortList = new ArrayList<>();
        sortList.add(1);
        this.sourceMenuSortList = sortList;
    }

}
