package com.yaoyaozw.customer.controller;

import com.yaoyaozw.customer.common.BaseResult;
import com.yaoyaozw.customer.common.GenericsResult;
import com.yaoyaozw.customer.dto.ConditionDTO;
import com.yaoyaozw.customer.dto.DistributeDTO;
import com.yaoyaozw.customer.service.DistributeService;
import com.yaoyaozw.customer.vo.AccountDistributeLogVO;
import io.swagger.annotations.Api;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * @Author: Dwl
 * @Date: 2024/03/27/17:14
 * @ClassName: DistributeController
 * @Version: V3.2.0
 * @Description:
 */
@Api(tags = "分发复用")
@RestController
@RequestMapping("/distribute")
public class DistributeController {
    @Autowired
    private DistributeService distributeService;

    @PostMapping("/distribute")
    public BaseResult distribute(@RequestBody DistributeDTO distributeDTO) {
        return distributeService.distribute(distributeDTO);
    }

    @PostMapping("/logList")
    public GenericsResult<List<AccountDistributeLogVO>> getList() {
        return distributeService.logList();
    }
}
