package com.yaoyaozw.customer.scheduling;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.yaoyaozw.customer.constants.CustomerCommonConstant;
import com.yaoyaozw.customer.dto.integration.IntegrationRequestDTO;
import com.yaoyaozw.customer.entity.CrowdPackage;
import com.yaoyaozw.customer.service.AccountOrderService;
import com.yaoyaozw.customer.service.RegisterUserEntityService;
import com.yaoyaozw.customer.service.impl.CrowdPackageServiceImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;

@Component
public class SchedulingTask {

    private final static Logger localLog = LoggerFactory.getLogger(SchedulingTask.class);

    @Autowired
    private AccountOrderService accountOrderService;

    @Autowired
    private RegisterUserEntityService registerUserEntityService;
    @Autowired
    private RedisTemplate redisTemplate;
    @Autowired
    private CrowdPackageServiceImpl crowdPackageService;


    /**
     * 拉取付费订单(每15min一次)
     */
    public void retrieveOrderData(){

        Calendar calendar = Calendar.getInstance();

        calendar.set(Calendar.SECOND, 0);

        calendar.set(Calendar.MILLISECOND, 0);

        IntegrationRequestDTO integrationRequestDTO = new IntegrationRequestDTO();

        accountOrderService.activeUserByOrder(integrationRequestDTO);
    }

    /**
     * 更新付费用户近一月平均充值(每天一次）
     */
    public void retrieveMonthOrder(){

        Calendar calendar = Calendar.getInstance();

        calendar.set(Calendar.SECOND, 0);

        calendar.set(Calendar.MILLISECOND, 0);

        IntegrationRequestDTO integrationRequestDTO = new IntegrationRequestDTO();

        accountOrderService.calculateAvgMonth(integrationRequestDTO);

    }


    /**
     * 每10min扫描一次正常客服
     */
    public void publishCustomerMessage(){


    }


    /**
     * 每1min扫延时客服
     */
    public void publishDelayCustomerMessage(){


    }

    /**
     * 从redis中更新人群包人数
     */
    @Scheduled(cron = "0 0/15 * * * ?")
    public void updateCrowdPackageNumFromRedis() {
        localLog.info("开始同步redis中人群包人数至数据库");
        HashMap<String, Integer> entries = (HashMap<String, Integer>) redisTemplate.boundHashOps(CustomerCommonConstant.CROWD_HUMAN_NUN_REDIS_KEY).entries();
        if (CollectionUtil.isEmpty(entries)) {
            return;
        }
        localLog.info("redis中获取到人群包人数数据: {}对", entries.size());
        Date now = new Date();
        List<CrowdPackage> list = crowdPackageService.list();
        localLog.info("数据库中获取人群包: {}条", list.size());
        List<CrowdPackage> resultList = list.stream().filter(item -> entries.containsKey(item.getId().toString()))
                .peek(item -> {
                    item.setLastCountTime(now);
                    Integer num = entries.get(item.getId().toString());
                    item.setCrowdNum(num);
                }).collect(Collectors.toList());

        if (entries.size() != list.size()) {
            localLog.info("删除redis在数据库中不存在的人群包");
            List<String> idList = list.stream().map(item -> String.valueOf(item.getId())).collect(Collectors.toList());
            for (String key : entries.keySet()) {
                if (!idList.contains(key)) {
                    localLog.info("redis中人群包id: {} 在数据库中不存在, 删除", key);
                    redisTemplate.opsForHash().delete(CustomerCommonConstant.CROWD_HUMAN_NUN_REDIS_KEY, key);
                }
            }
        }

        localLog.info("要更新人群包: {} 条", resultList.size());
        if (CollectionUtil.isNotEmpty(resultList)) {
            crowdPackageService.updateBatchById(resultList);
        }
        localLog.info("删除创建时的临时数据");
        crowdPackageService.remove(new QueryWrapper<CrowdPackage>().isNull("package_name"));

    }
}
