package com.yaoyaozw.customer.service.wechat.service;


import com.yaoyaozw.customer.entity.CustomerDelayPublish;
import com.yaoyaozw.customer.entity.RegisterUserEntity;
import com.yaoyaozw.customer.vo.customer.CustomerDelayItemVO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.scheduling.annotation.AsyncResult;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.Map;
import java.util.concurrent.Future;

@Service
public class WeChatServiceImpl implements WeChatService{

    @Autowired
    private WeChatRestService weChatRestService;

    @Async("myExecutor")
    @Override
    public Future<CustomerDelayPublish> sendCustomerDelayMessage(String token, CustomerDelayPublish user, Map<Integer,CustomerDelayItemVO> delaySortMap) {

        //根据公众号发送客服


        //当前时间批次发文素材的用户关注时间一致
        Long subscribeTimestamp = user.getGmtCreate().getTime();

        Integer newSort = user.getCustomerSort()+1;

        CustomerDelayItemVO customerDelayItemVO = delaySortMap.get(newSort);

        if (customerDelayItemVO!=null&&customerDelayItemVO.getTimeInterval()!=null){

            user.setCustomerSort(newSort);

            user.setCustomerPublish(new Date(subscribeTimestamp+customerDelayItemVO.getTimeInterval()));
        }
        return new AsyncResult<>(user);
    }
}
