package com.yaoyaozw.customer.vo.customer;

import cn.hutool.core.util.ObjectUtil;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.yaoyaozw.customer.constants.CustomerCommonConstant;
import com.yaoyaozw.customer.dto.customer.CustomerReferralDTO;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.apache.commons.lang3.StringUtils;

import java.io.Serializable;

/**
 * @author darker
 * @date 2022/10/12 11:31
 */
@Data
public class CustomerContentVO implements Serializable {

    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("子文本主键")
    private Long id;

    @ApiModelProperty("文本内容")
    private String content;

    @ApiModelProperty("链接相关内容")
    private CustomerReferralDTO customerReferralDto;

    @ApiModelProperty("是否可编辑")
    private Boolean editable;

    public Boolean getEditable() {
        if (ObjectUtil.isNull(this.customerReferralDto)) {
            return true;
        }
        // 如果是需要远程获取链接的，并且链接已经生成的，则不能再进行编辑
        return !(CustomerCommonConstant.REMOTE_LINK_NEWS_TYPE_LIST.contains(this.customerReferralDto.getNewsType()) && StringUtils.isNotBlank(this.customerReferralDto.getReferral()));
    }
}
